package com.digiwin.mobile.mobileuibot.feedback;

import java.util.Objects;

/**
 * <p>功能描述：智能助理对话中的反馈类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AiChatFeedbackTypeEnum
 * @Author: zaregoto
 * @Date: 2024/1/25 21:47
 */
public enum AiChatFeedbackTypeEnum {
    /**
     * 点赞
     */
    GOOD(0),

    /**
     * 点踩
     */
    BAD(1),
    
    ;

    private final Integer value;

    AiChatFeedbackTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static AiChatFeedbackTypeEnum getEnumByValue(Integer value) {
        for (AiChatFeedbackTypeEnum testedEnum : AiChatFeedbackTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
