package com.digiwin.mobile.mobileuibot.feedback;

import com.digiwin.mobile.mobileuibot.api.ApiRequestAgileDataInAiChat;
import com.digiwin.mobile.mobileuibot.api.DeviceInfo;
import com.digiwin.mobile.mobileuibot.api.EnumIntegerConstraint;
import com.digiwin.mobile.mobileuibot.api.EnumStringConstraint;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>功能描述：智能助理会话中反馈操作的请求模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestFeedbackAiChat
 * @Author: zaregoto
 * @Date: 2024/1/25 21:21
 */
@Data
public class ApiRequestFeedbackActionInAiChat extends ApiRequestAgileDataInAiChat {
    private static final long serialVersionUID = -5204269852944788029L;

    /**
     * 会话信息
     */
    @Valid
    @NotNull(message = "chatInfo must be valid")
    private ChatInfo chatInfo;

    /**
     * 设备信息
     */
    private DeviceInfo deviceInfo;

    /**
     * 反馈类型
     *
     * @see AiChatFeedbackTypeEnum
     */
    @EnumIntegerConstraint(value = {0, 1}, message = "feedbackType must be valid")
    private Integer feedbackType;

    /**
     * 敏捷数据快照id
     */
    private String snapshotId;

    /**
     * 租户名称
     */
    @NotBlank(message = "tenantName must be valid")
    private String tenantName;

    /**
     * 用户名称（和前端个人页上的姓名对应，如张三、王五）
     */
//    @NotBlank(message = "userName must be valid")
    private String userName;
}

/**
 * 与智能助理交互的会话信息，用于描述用户反馈
 */
@Data
class ChatInfo implements Serializable {

    private static final long serialVersionUID = -1983532570574706524L;

    /**
     * 答复文本
     */
    @NotBlank(message = "chatinfo.a must be valid")
    private String a;

    /**
     * 答复时间
     */
    @NotBlank(message = "chatinfo.aTime must be valid")
    @JsonProperty(value = "aTime")
    private String aTime;

    /**
     * 聊天气泡高度
     */
    private Double bubbleHeight;

    /**
     * 聊天气泡宽度
     */
    private Double bubbleWidth;

    /**
     * 问题文本
     */
    @NotBlank(message = "chatinfo.qu must be valid")
    private String qu;

    /**
     * 问题发出时间
     */
    @NotBlank(message = "chatinfo.quTime must be valid")
    @JsonProperty(value = "quTime")
    private String quTime;

    /**
     * 使用的助理技能类型。
     *
     * @see com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum
     */
    @EnumStringConstraint(value = {"1", "2", "3"}, message = "chatinfo.skillType must be valid")
    private String skillType;
}