package com.digiwin.mobile.mobileuibot.feedback;

import com.digiwin.mobile.mobileuibot.api.ApiRequestAgileDataInAiChat;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：智能助理会话中反馈内容提交的请求模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestFeedbackCommentInAiChat
 * @Author: zaregoto
 * @Date: 2024/1/25 21:51
 */
@Data
public class ApiRequestFeedbackCommentInAiChat extends ApiRequestAgileDataInAiChat {
    private static final long serialVersionUID = -523631371690390258L;

    /**
     * 用户反馈选项清单。和opinion至少有一个
     */
    private List<FeedbackChoiceContent> backContent = new ArrayList<>(1);

    /**
     * 更多反馈文字内容。和backContent至少有一个
     */
    private String opinion = "";

    /**
     * 敏捷数据快照id
     */
    private String snapshotId;
}

/**
 * 反馈选项内容
 */
@Data
class FeedbackChoiceContent implements Serializable {
    private Integer id;
    private String text;
}
