package com.digiwin.mobile.mobileuibot.file;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.mobile.mobileuibot.api.*;
import com.digiwin.mobile.mobileuibot.file.fileupload.UploadFile;
import com.digiwin.mobile.mobileuibot.model.db1.FileUploadRecord;

import java.util.List;
import java.util.Map;

/**
 * 上传文件业务类
 *
 * @author wuyang
 */
public interface FileService extends IService<FileUploadRecord> {

    /**
     * 上传图片
     *
     * @param apiAttachment
     * @return
     */
    Map<String, Object> uploadFile(ApiUploadAttachment apiAttachment, int uploadPC);


    /**
     * 签名图片上传
     *
     * @param strBase64
     * @param buckets
     * @param uploadCategory
     * @param disableAam
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    Map<String, Object> uploadFile(String strBase64, String buckets, String uploadCategory,
                                   boolean disableAam, String iamUserToken, String tenantId);

    /**
     * 上传文件
     *
     * @param uploadFile
     * @return
     */
    Map<String, Object> uploadFile(UploadFile uploadFile);


    /**
     * 分段上传文件
     *
     * @param uploadFile
     * @return
     */
    String segmentedUploadFile(ApiSegmentedUploadAttachment uploadFile);

    /**
     * 敏捷数据lite版本:上传文件
     *
     * @param apiAttachment
     * @return
     */
    ApiResponse uploadFileAgileData(AgileDataUploadAttachment apiAttachment);

    /**
     * 敏捷数据lite版本:获取指定目录下的文件列表
     *
     * @param apiRequest
     * @return
     */
    List<Map<String, String>> getDirFileList(ApiRequest apiRequest);
}