package com.digiwin.mobile.mobileuibot.file.fileupload;

import com.digiwin.mobile.mobileuibot.task.model.TbdsOpStatusEnum;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 功能: 文件上传位置
 *
 * @author: wjw
 * @date: created at 2023/2/21
 */
@Getter
public enum ContentTypeEnum {
    JPEG("jpeg", "image/jpeg"),

    JPG("jpg", "image/jpeg"),

    PNG("png", "image/png"),

    WEBP("webp", "image/webp"),

    PDF("pdf", "application/pdf"),

    MP3("mp3", "audio/mpeg"),

    WAV("wav" , "audio/wav"),

    WEBA("weba" , "audio/webm"),

    MPEG("mpeg", "video/mpeg"),

    WEBM("webm", "video/webm"),

    MP4("mp4", "video/mp4"),
    ;

    private String fileExtendName;

    private String contentType;

    ContentTypeEnum(String fileExtendName, String contentType) {
        this.fileExtendName = fileExtendName;
        this.contentType = contentType;
    }

    public static String getContentTypeByName(String fileExtendName) {
        if(StringUtils.isEmpty(fileExtendName)){
            return StringUtils.EMPTY;
        }
        for (ContentTypeEnum item : ContentTypeEnum.values()) {
            if (item.getFileExtendName().equalsIgnoreCase(fileExtendName)) {
                return item.getContentType();
            }
        }
        return StringUtils.EMPTY;
    }
}
