package com.digiwin.mobile.mobileuibot.gptai;

import com.digiwin.mobile.mobileuibot.sso.model.EnvironmentalConfiguration;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 集成各个GPT AI 配置类
 *
 * @author yanfeng
 * @date 2023/9/22
 */

@Document("gptAiConfig")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GptAiModel implements Serializable {

    private static final long serialVersionUID = 2328702638076216681L;
    @MongoId(FieldType.OBJECT_ID)
    private String _id;

    /**
     * 应用code（查询是否购买使用）
     */
    private String code;

    /**
     * 集成系统的应⽤ ID,移动：Athena_mobile
     */
    private String appId;

    /**
     * 主标题
     */
    private String title;

    /**
     * 副标题
     */
    private String sbuTitle;

    /**
     * 图标
     */
    private String icon;

    /**
     * 返回给前端的url链接
     */
    private String urlLink;


    /**
     * 配置参数
     * Map key(固定)： CN,TW
     */
    private Map<String, List<EnvironmentalConfiguration>> parameterMap;

    /**
     * 开关:是否显示
     */
    private Boolean switchShow;

    /**
     * 开关:是否可以点击
     */
    private Boolean switchClick;

    /**
     * 开关:是否购买
     */
    private Boolean switchBuy;

    /**
     * 开关:是否开放
     */
    private Boolean switchOpen;

    /**
     * toast消息
     */
    private String toastMessage;

    /**
     * 排序
     */
    private Integer sort;
}
