package com.digiwin.mobile.mobileuibot.gptai;

import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Example;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author yanfeng
 * @date 2023/9/22
 */
@Service
public class GptAiServiceImpl implements GptAiService {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private HttpService httpService;

    @Autowired
    private GptAiRepository gptAiRepository;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private MongoTemplate mongoTemplate;


    @Override
    public List<GptAiModel> findAll(String locale) {
        GptAiModel gptAiModel = new GptAiModel();
        Example<GptAiModel> example = Example.of(gptAiModel);
        List<GptAiModel> gptAiModelList = gptAiRepository.findAll(example);
        for (GptAiModel aiModel : gptAiModelList) {
            aiModel.setTitle(localeService.getLanguageValue(locale, aiModel.getTitle()));
            aiModel.setSbuTitle(localeService.getLanguageValue(locale, aiModel.getSbuTitle()));
            aiModel.setToastMessage(localeService.getLanguageValue(locale, aiModel.getToastMessage()));
        }
        gptAiModelList.sort(Comparator.comparing(GptAiModel::getSort));
        return gptAiModelList;
    }

    @Override
    public GptAiModel insertOrUpdateGptAi(GptAiModel gptAi) {
        GptAiModel gptAiModel = new GptAiModel();
        gptAiModel.setIcon(gptAi.getIcon());
        Example<GptAiModel> example = Example.of(gptAiModel);
        Optional<GptAiModel> optional = gptAiRepository.findOne(example);
        if (optional.isPresent()) {
            //更新
            Query query = new Query(Criteria.where("icon").is(gptAi.getIcon()));
            Update update = new Update();
            if (StringUtils.isNotBlank(gptAi.getTitle())) {
                update.set("title", gptAi.getTitle());
            }
            if (StringUtils.isNotBlank(gptAi.getCode())) {
                update.set("code", gptAi.getCode());
            }
            if (StringUtils.isNotBlank(gptAi.getAppId())) {
                update.set("appId", gptAi.getAppId());
            }
            if (StringUtils.isNotBlank(gptAi.getSbuTitle())) {
                update.set("sbuTitle", gptAi.getSbuTitle());
            }
            if (ObjectUtils.isNotEmpty(gptAi.getSwitchShow())) {
                update.set("switchShow", gptAi.getSwitchShow());
            }
            if (ObjectUtils.isNotEmpty(gptAi.getSwitchClick())) {
                update.set("switchClick", gptAi.getSwitchClick());
            }
            if (StringUtils.isNotBlank(gptAi.getIcon())) {
                update.set("icon", gptAi.getIcon());
            }
            if (StringUtils.isNotBlank(gptAi.getUrlLink())) {
                update.set("urlLink", gptAi.getUrlLink());
            }
            if (StringUtils.isNotBlank(gptAi.getToastMessage())) {
                update.set("toastMessage", gptAi.getToastMessage());
            }
            if (ObjectUtils.isNotEmpty(gptAi.getSort())) {
                update.set("sort", gptAi.getSort());
            }
            mongoTemplate.updateMulti(query, update, GptAiModel.class);
            Optional<GptAiModel> one = gptAiRepository.findOne(example);
            return one.orElseGet(GptAiModel::new);
        } else {
            //新增
            return gptAiRepository.save(gptAi);
        }
    }

    @Override
    public Boolean pushReport(String report, String userId,
                              String iamUserToken, String tenantId) {
        String url = sysEnvConfig.getSdAiUrl() + "/scrumbi/pushReport";
        Map<String, Object> body = new HashMap<>(3);
        body.put("tenantId", tenantId);
        body.put("userId", userId);
        body.put("report", report);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(body), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            return true;
        }
        return false;
    }
}