package com.digiwin.mobile.mobileuibot.im;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.im.addmembers.IMAddMembersRequest;
import com.digiwin.mobile.mobileuibot.im.getuserinfo.ImUserInfoRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfoTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeamTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.HttpStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * IM相关对外接口
 *
 * @author zhangjj
 * @date 2021/9/9 0009 15:15
 */
@RestController
@RequestMapping("/mobile/v1/im")
public class IMController {

    /**
     * 企业用户(外部用户)
     */
    public static final int PERSON_TYPE_ENTERPRISER = 1;
    /**
     * 内部用户
     */
    public static final int PERSON_TYPE_INTERNAL_USER = 0;

    @Autowired
    private IMService imService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    /**
     * 获取云信账密
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/user/info", method = RequestMethod.POST)
    public ApiResponse<IMUser> getNimLoginInfo(HttpServletRequest request) throws IOException {
        //敏捷问数下地跳过,ESP不下地
        if (BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK();
        }

        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = String.valueOf(params.get("tenantId"));
        Object nanaTenantId = request.getAttribute("nanaTenantId");
        if (nanaTenantId != null) {
            tenantId = nanaTenantId.toString();
        }
        IMUser imUser = imService.getIMUserByToken(iamUserToken, tenantId);
        if (imUser != null && StringUtils.hasLength(imUser.getAccid())) {
            return ApiResponse.buildOK().setData(imUser);
        }
        return ApiResponse.buildError();
    }

    /**
     * 得到当前人员的信息
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/user/getAndCreate", method = RequestMethod.POST)
    public ApiResponse<IMUser> getAndCreateUserInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = String.valueOf(params.get("tenantId"));
        IMUser imUser = imService.getAndCreateIMUserByToken(iamUserToken, tenantId);
        if (imUser != null) {
            return ApiResponse.buildOK().setData(imUser);
        }
        return ApiResponse.buildError();
    }

    /**
     * （右滑摇人--得到该项目下所有任务群聊 -- 暂废除）
     * 获取某个项目下关联的所有任务
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/project/tasklist", method = RequestMethod.POST)
    public ApiResponse<List<DigiwinAtmcTask>> getTaskList(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String projectID = (String) params.get("projectId");
        String locale = (String) params.get("locale");
        // FIXME 后续要在本接口重新启用后，请前端传入租户ID
        String tenantId = "";
        List<DigiwinAtmcTask> digiwinAtmcTasks = digiwinAtmcProxyService.getTaskListByProjectId(projectID, iamUserToken, tenantId, locale);
        if (digiwinAtmcTasks != null && digiwinAtmcTasks.size() > 0) {
            return ApiResponse.buildOK().setData(digiwinAtmcTasks);
        }
        return ApiResponse.buildError();
    }

    /**
     * （获取所有项目和群聊 -- 暂废除---）
     *
     * @param request
     * @return
     * @throws IOException
     */
    @Deprecated
    @RequestMapping(value = "/project/getAllTaskAndBackLog", method = RequestMethod.POST)
    public ApiResponse getAllTaskAndBackLog(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.getOrDefault("iamUserToken", "");
        String clientId = (String) params.getOrDefault("clientId", "");
        String locale = (String) params.getOrDefault("locale", "");
        String tenantId = (String) params.getOrDefault("tenantId", "");
//        List<DigiwinAtmcProject> digiwinAtmcProjects = digiwinAtmcProxyService.getAllProjectListByClientId(clientId, iamUserToken, locale, tenantId);
//        List<DigiwinAtmcBacklog> digiwinAtmcBacklogs = digiwinAtmcProxyService.getAllTaskListByClientId(clientId, iamUserToken, locale);
        return ApiResponse.buildError();
    }

    /**
     * 创建项目/任务相关的群聊
     *
     * @param request
     * @param imTeam
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/team/create", method = RequestMethod.POST)
    public ApiResponse<IMTeam> teamCreate(HttpServletRequest request, @RequestBody IMTeam imTeam) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = String.valueOf(params.get("tenantId"));
        if (params.get("pId") != null && StringUtils.hasLength((String) params.get("pId"))) {
            imTeam.setPId((String) params.get("pId"));
        }
        DigiwinAthenaApiResponse<String> createResponse = imService.teamCreate(iamUserToken, imTeam, tenantId);
        boolean createSuccess = createResponse.getStatus() == HttpStatus.SC_OK;
        if (createSuccess) {
            return ApiResponse.buildOK(createResponse.getResponse()).setData(imTeam);
        } else {
            return ApiResponse.buildError(createResponse.getStatusDescription()).setData(imTeam);
        }
    }

    /**
     * 群加人操作
     *
     * @param imAddMembersRequest
     * @return
     */
    @RequestMapping(value = "/team/addmembers", method = RequestMethod.POST)
    public ApiResponse<IMAddMembersRequest> addMembers(@RequestBody IMAddMembersRequest imAddMembersRequest) {
        DigiwinAthenaApiResponse<String> addResponse = this.imService.teamAddMembers(imAddMembersRequest);
        boolean addMembersSuccess = addResponse.getStatus() == HttpStatus.SC_OK;
        if (addMembersSuccess) {
            return ApiResponse.buildOK(addResponse.getResponse()).setData(imAddMembersRequest);
        } else {
            return ApiResponse.buildError(addResponse.getStatusDescription()).setData(imAddMembersRequest);
        }
    }

    /**
     * 返回IM群聊中的所有用户信息，并针对企业类型用户设置企业名称
     *
     * @param imUserInfoRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/getEnterpriseUserInfo", method = RequestMethod.POST)
    public ApiResponse<List<DigiwinIamUserInfo>> getEnterpriseUserInfo(
            @RequestBody ImUserInfoRequest imUserInfoRequest) throws IOException {
        String locale = imUserInfoRequest.getLocale();
        String iamUserToken = imUserInfoRequest.getIamUserToken();
        List<String> userIds = imUserInfoRequest.getUserIds();
        List<DigiwinIamUserInfo> userInfos = this.digiwinIamProxyService.userList(userIds, iamUserToken, locale);

        if (null == userInfos) {
            return ApiResponse.buildError("error occurred in get user list from Digiwin IAM");
        }
        String enterpriseTypeUserEnterpriseName = LocaleUtil.getMobileTextByKey(locale, "企业用户");
        for (DigiwinIamUserInfo userInfo : userInfos) {
            if (Objects.equals(DigiwinIamUserInfoTypeEnum.ENTERPRISE.getValue(), userInfo.getType())) {
                userInfo.setEnterpriseName(enterpriseTypeUserEnterpriseName);
            }
        }
        return ApiResponse.buildOK().setData(userInfos);
    }

    /**
     * 通过群聊ID返回内部人员列表
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/getTeamMembers", method = RequestMethod.POST)
    public ApiResponse<TeamInfo> getTeamMembers(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String teamId = (String) params.get("teamId");
        Integer type = (Integer) params.get("type");
        String clientId = (String) params.get("clientId");
        String locale = (String) params.get("locale");
        String pId = (String) params.get("pId");
        String bizId = (String) params.get("bizId");
        String tenantId = String.valueOf(params.get("tenantId"));

        TeamInfo teamInfo = getTeamMembers(iamUserToken, teamId, type, locale, bizId, tenantId);
        return ApiResponse.buildOK().setData(teamInfo);
    }

    @NotNull
    private TeamInfo getTeamMembers(String iamUserToken, String teamId, Integer type, String locale, String bizId, String tenantId) {
        TeamInfo teamInfo = new TeamInfo();
        String pattern = "^\\d+";
        //是否为纯数字
        boolean isNumber = bizId.matches(pattern);
        if (Objects.equals(type, IMTeamTypeEnum.PROJECT_TYPE.getValue())) {
            DigiwinAtmcProject digiwinAtmcProject = null;
            if (isNumber) {
                digiwinAtmcProject = this.digiwinAtmcProxyService.getDigiwinAtmcProjectByAimMessage(locale, iamUserToken, bizId, "task");
            }
            if (digiwinAtmcProject != null) {
                if (dealDateFormat(digiwinAtmcProject.getStartTime()) == null) {
                    teamInfo.setTitle("");
                } else {
                    teamInfo.setTitle(dealDateFormat(digiwinAtmcProject.getStartTime()) + "~" + dealDateFormat(digiwinAtmcProject.getEndTime()));
                }
                teamInfo.setType(IMTeamTypeEnum.PROJECT_TYPE.getValue() + "");
            }
        } else if (Objects.equals(type, IMTeamTypeEnum.TASK_TYPE.getValue())) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = null;
            if (isNumber) {
                digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, bizId);
            }
            if (digiwinAtmcBacklogDetail != null) {
                if (dealDateFormat(digiwinAtmcBacklogDetail.getEndTime()) == null) {
                    teamInfo.setTitle("");
                } else {
                    teamInfo.setTitle(dealDateFormat(digiwinAtmcBacklogDetail.getEndTime()) + "需完成");
                }
                teamInfo.setType(IMTeamTypeEnum.TASK_TYPE.getValue() + "");
            }
        }
        List<TeamMember> teamMembers = imService.getTeamMembers(iamUserToken, teamId, tenantId);
        if (CollectionUtils.isEmpty(teamMembers)) {
            teamInfo.setTeamMembers(new ArrayList<>(1));
        } else {
            List<TeamMember> newTeamMembers = new ArrayList<>(teamMembers.size());
            for (TeamMember teamMember : teamMembers) {
                if (teamMember.getType() == PERSON_TYPE_INTERNAL_USER) {
                    newTeamMembers.add(teamMember);
                }
            }
            if (newTeamMembers.size() > 0) {
                newTeamMembers = imService.setAccId(newTeamMembers, iamUserToken);
                teamInfo.setTeamMembers(newTeamMembers);
            }
        }
        return teamInfo;
    }

    /**
     * 查询应用到期消息提醒
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/expire/application/notice", method = RequestMethod.POST)
    public ApiResponse<ExpireApplicationNoticeDetail> getExpireApplicationNoticeInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String userId = (String) params.get("userId");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = (String) params.get("tenantId");
        String locale = (String) params.get("locale");
        ExpireApplicationNoticeDetail expireApplicationNoticeDetail = imService.getExpireApplicationNoticeInfo(userId, iamUserToken, tenantId, locale);
        return ApiResponse.buildOK().setData(expireApplicationNoticeDetail);
    }

    private String dealDateFormat(String date) {
        if (date != null) {
            try {
                String[] dates = date.split(" ")[0].split("-");
                return dates[1] + "/" + dates[2];
            } catch (Exception e) {
                e.printStackTrace();
                return date;
            }

        }
        return null;
    }
}