package com.digiwin.mobile.mobileuibot.im;

import com.digiwin.mobile.mobileuibot.im.addmembers.IMAddMembersRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeDetail;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;

import java.util.List;

/**
 * <p>功能描述：IM服务处理</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IMService
 * @Author: Zaregoto
 * @Date: 2022/6/8 17:13
 */
public interface IMService {

    /**
     * 根据token获取云信账号信息
     *
     * @param iamUserToken
     * @return
     */
    IMUser getIMUserByToken(String iamUserToken, String tenantId);

    /**
     * 根据token得到当前人员的信息
     *
     * @param iamUserToken
     * @return
     */
    IMUser getAndCreateIMUserByToken(String iamUserToken, String tenantId);

    /**
     * 创建项目/任务关联群聊
     *
     * @param iamUserToken
     * @param imTeam
     * @return
     */
    DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId);

    /**
     * 获取群聊下内部成员列表
     *
     * @param iamUserToken
     * @param teamId
     * @return
     */
    List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId);

    /**
     * 批量塞入云信账号ID
     *
     * @param newTeamMembers
     * @param iamUserToken
     * @return
     */
    List<TeamMember> setAccId(List<TeamMember> newTeamMembers, String iamUserToken);

    /**
     * 群聊加人
     *
     * @param imAddMembersRequest
     * @return
     */
    DigiwinAthenaApiResponse<String> teamAddMembers(IMAddMembersRequest imAddMembersRequest);


    /**
     * 查询应用到期消息提醒
     *
     * @param userId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    ExpireApplicationNoticeDetail getExpireApplicationNoticeInfo(String userId, String iamUserToken, String tenantId, String locale);
}
