package com.digiwin.mobile.mobileuibot.im;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.im.addmembers.IMAddMembersRequest;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.AppExpireNoticeRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.AppExpireNoticeRecordService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeDetail;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeInfo;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ImServiceImpl
 * @Author: Zaregoto
 * @Date: 2022/6/8 17:16
 */
@Service("imService")
public class IMServiceImpl implements IMService {

    private static final String YUN_XIN = "1";
    private static final String AGORA = "2";
    private static final String OPENFIRE = "3";

    private static final Logger logger = LoggerFactory.getLogger(IMServiceImpl.class);

    @Autowired
    private DigiwinImProxyService digiwinImProxyService;

    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private AppExpireNoticeRecordService appExpireNoticeRecordService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Override
    public IMUser getIMUserByToken(String iamUserToken, String tenantId) {
        IMUser imUser = this.digiwinImProxyService.userLoginAndCreate(iamUserToken, tenantId);
        // 云信依据雅典娜平台的地址，返回IM所需的环境名称和智能助理的账号id
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        if (Objects.equals(sysEnvConfig.getImTypeJudgeLocalUrl(), athenaMuiUrl)) {
            // 下地时，根据启动脚本配置的Url判断，设置imType=3
            imUser.setImType(OPENFIRE);
        } else if (Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
            // paas区
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("ania_paas");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
            // 华为测试区
            imUser.setAiAssistantAccId("test_cnhw_4931");
            imUser.setEnvName("ania_hw_test");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
            // 华为正式区
            imUser.setAiAssistantAccId("prod_cnhw_28169");
            imUser.setEnvName("ania_hw");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
            // 微软测试区，用agora
            imUser.setAiAssistantAccId("test_azure_3301");
            imUser.setEnvName("ania_test_tw");
            imUser.setImType(AGORA);
        } else if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
            // 微软正式区，未来用agora
            imUser.setAiAssistantAccId("prod_tw_38916");
            imUser.setEnvName("ania_azure");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-hz-test.digiwincloud.com.cn", athenaMuiUrl)) {
            // 湖州环境
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("semc_paas");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-pressure.digiwincloud.com.cn", athenaMuiUrl)) {
            // 华为云压测环境
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("ania_hw_pressure");
            imUser.setImType(YUN_XIN);
        } else {
            // TODO 未来定制或其他特殊情况
            imUser.setAiAssistantAccId("");
            imUser.setEnvName("");
        }
        return imUser;
    }

    @Override
    public IMUser getAndCreateIMUserByToken(String iamUserToken, String tenantId) {
        return this.digiwinImProxyService.userGetAndCreate(iamUserToken, tenantId, null);
    }

    @Override
    public DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId) {
        //将群主的accid转为eocId
        EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(imTeam.getOwner(), iamUserToken, 2);
        if (eocPersonInfo != null && StringUtils.hasLength(eocPersonInfo.getEocId())) {
            imTeam.setOwner(eocPersonInfo.getEocId());
        }
        List<String> eocIds = new ArrayList<>(imTeam.getMemberIds().size());
        for (String userId : imTeam.getMemberIds()) {
            EocPersonInfo eocPersonInfo1 = this.digiwinEocProxyService.getEocPersonInfo(userId, iamUserToken, 2);
            if (eocPersonInfo1 != null && StringUtils.hasLength(eocPersonInfo1.getEocId())) {
                eocIds.add(eocPersonInfo1.getEocId());
            }
        }
        if (eocIds == null || eocIds.size() < imTeam.getMemberIds().size()) {
            eocIds = imTeam.getMemberIds();
        }
        imTeam.setMemberIds(eocIds);
        return this.digiwinImProxyService.teamCreate(iamUserToken, imTeam, tenantId);
    }

    @Override
    public List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId) {
        return this.digiwinImProxyService.getTeamMembers(iamUserToken, teamId, tenantId);
    }

    @Override
    public List<TeamMember> setAccId(List<TeamMember> newTeamMembers, String iamUserToken) {
        for (TeamMember teamMember : newTeamMembers) {
            EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(teamMember.getEocId(),
                    iamUserToken, 1);
            teamMember.setAccId(eocPersonInfo.getAccId());
        }
        return newTeamMembers;
    }

    @Override
    public DigiwinAthenaApiResponse<String> teamAddMembers(IMAddMembersRequest imAddMembersRequest) {
        return this.digiwinImProxyService.teamAddMembers(
                imAddMembersRequest.getIamUserToken(),
                imAddMembersRequest.getTeamId(),
                imAddMembersRequest.getMemberIds(),
                imAddMembersRequest.getBizIdFromServerCustomInfo(),
                imAddMembersRequest.getIMTeamTypeFromServerCustomInfo(),
                imAddMembersRequest.getTenantId()
        );
    }

    @Override
    public ExpireApplicationNoticeDetail getExpireApplicationNoticeInfo(String userId, String iamUserToken, String tenantId, String locale) {
        ExpireApplicationNoticeDetail expireApplicationNoticeDetail = new ExpireApplicationNoticeDetail();
        try {
            List<ExpireApplicationNoticeInfo> expireApplicationNoticeInfoList = this.digiwinAimProxyService.getExpireApplicationNoticeInfo(iamUserToken, tenantId);

            Map<String, String> param = new HashMap<>(2);
            param.put("userId", userId);
            param.put("tenantId", tenantId);

            if (CollectionUtils.isEmpty(expireApplicationNoticeInfoList)) {
                appExpireNoticeRecordService.deleteData(param);
                expireApplicationNoticeDetail.setContentList(Collections.emptyList());
                return expireApplicationNoticeDetail;
            }

            List<AppExpireNoticeRecord> appExpireNoticeRecordList = appExpireNoticeRecordService.getInfo(param);

            Set<String> oldNoticeGid = appExpireNoticeRecordList.stream().map(e -> e.getNoticeGid()).collect(Collectors.toSet());
            Set<String> newNoticeGid = expireApplicationNoticeInfoList.stream().map(e -> e.getGid()).collect(Collectors.toSet());

            // 筛选需要展示的新的提醒
            List<ExpireApplicationNoticeInfo> newNoticeList = expireApplicationNoticeInfoList.stream().filter(e -> !oldNoticeGid.contains(e.getGid())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(newNoticeList)) {
                expireApplicationNoticeDetail.setContentList(Collections.emptyList());
                return expireApplicationNoticeDetail;
            }

            // 有新的提醒需要入库，供下一次比较来筛选新数据
            List<AppExpireNoticeRecord> appExpireNoticeRecordAddInfoList = newNoticeList.stream().map(e ->
                    {
                        AppExpireNoticeRecord appExpireNoticeRecord = new AppExpireNoticeRecord();
                        appExpireNoticeRecord.setId(UUIDUtil.getLongUuid());
                        appExpireNoticeRecord.setUserId(userId);
                        appExpireNoticeRecord.setTenantId(tenantId);
                        appExpireNoticeRecord.setNoticeGid(e.getGid());
                        appExpireNoticeRecord.setNoticeMsg(e.getContent().getMsg());
                        appExpireNoticeRecord.setNoticeTime(new Date());
                        appExpireNoticeRecord.setCreateTime(new Date());
                        return appExpireNoticeRecord;
                    }
            ).collect(Collectors.toList());
            appExpireNoticeRecordService.batchInsertData(appExpireNoticeRecordAddInfoList);

            // 数据库老的不存在的消息需要删除
            List<String> inVaLidOldNoticeGid = oldNoticeGid.stream().filter(e -> !newNoticeGid.contains(e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(inVaLidOldNoticeGid)) {
                Map<String, Object> deleteParam = new HashMap<>(3);
                deleteParam.put("userId", userId);
                deleteParam.put("tenantId", tenantId);
                deleteParam.put("gids", inVaLidOldNoticeGid);
                appExpireNoticeRecordService.deleteDataByGid(deleteParam);
            }

            List<String> contentList = newNoticeList.stream().map(e -> localeService.getLanguageValue(locale, e.getContent().getMsg())).collect(Collectors.toList());
            expireApplicationNoticeDetail.setContentList(contentList);
            expireApplicationNoticeDetail.setDisplayDuration(5L);
        } catch (Exception e) {
            expireApplicationNoticeDetail.setContentList(Collections.emptyList());
            logger.error("get app expire notice error: ", e);
        }
        return expireApplicationNoticeDetail;
    }
}