package com.digiwin.mobile.mobileuibot.im.addmembers;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ApiRequestIMAddMember
 * @Author: Zaregoto
 * @Date: 2022/6/8 20:06
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IMAddMembersRequest extends ApiRequest {

    private List<String> memberIds;
    private Map<String, Object> serverCustomInfo;
    private String teamId;

    /**
     * 从自定义数据中获取bizId。IM场景使用
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public String getBizIdFromServerCustomInfo() {
        return String.valueOf(serverCustomInfo.getOrDefault("bizId", ""));
    }

    /**
     * 从自定义数据中获取群组type。IM场景使用
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public Integer getIMTeamTypeFromServerCustomInfo() {
        Object rawType = this.getServerCustomInfo().get("type");
        return rawType instanceof Integer ? (Integer) rawType : null;
    }
}
