package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：敏捷问数下地端首页构造策略类</p>
 *
 * @FileName: indexBuildAgileDataPrivatizationStrategy
 * @Author: yanfenga
 * @Date: 2025/7/15
 */
@Component("indexBuildAgileDataPrivatizationStrategy")
public class IndexBuildAgileDataPrivatizationStrategy {

    public UiBotModel build(ApiRequest apiRequest) {
        String dslString = FileUtil.readText("./static/agiledata/index-agileData-privatization.json");
        PageSetting pageSetting = JsonUtil.jsonStringToObject(dslString, PageSetting.class);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case IndexNavBar.COMPONENT_TYPE:
                    IndexNavBar indexNavBar =
                            JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                    indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                    pageData.put(layout.getSchema(), indexNavBar);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea blankArea = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), BlankArea.class);
                    pageData.put(layout.getSchema(), blankArea);
                    break;
                case Empty.COMPONENT_TYPE:
                    Empty empty = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Empty.class);
                    pageData.put(layout.getSchema(), empty);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}