package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.index.DriveTips;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>功能描述：在途宝应用+“司机”角色+无车辆信息时出现如下画面，首页构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexBuildDriverNoVehicleZtbStrategy
 * @Author: Zaregoto
 * @Date: 2022/1/24 22:17
 */
@Component("indexBuildDriverNoVehicleZtbStrategy")
public class IndexBuildDriverNoVehicleZtbStrategy {

    @Autowired
    private ProjectService projectService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator<UiBotLayout> layoutIterator = uiBotModel.getLayout().iterator();
        List<UiBotLayout> layoutList = new ArrayList<>();
        //是否有"为你推荐"
        boolean haveRecommend = false;
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = layoutIterator.next();
            if (IndexNavBar.COMPONENT_TYPE.equals(layout.getType())
                    && pageData.get(layout.getSchema()) != null) {
                IndexNavBar indexNavBar =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                indexNavBar.initShortcutButton(apiRequest, projectService, localeService);
                pageData.put(layout.getSchema(), indexNavBar);
                layoutList.add(layout);
            } else if (UniSearch.COMPONENT_TYPE.equals(layout.getType())
                    && pageData.get(layout.getSchema()) != null) {
                UniSearch uniSearch = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put(layout.getSchema(), uniSearch);
                layoutList.add(layout);
            } else if (BlankArea.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                //有为你推荐时，也有"空白组件"
                if (haveRecommend) {
                    layoutList.add(layout);
                }
            } else if (DriveTips.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                DriveTips driveTips = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), DriveTips.class);
                driveTips.initSetting(localeService, locale);

                DigiwinIamUserInfo userInfo = digiwinIamProxyService
                        .userInfoById(apiRequest.getUserId(), apiRequest.getIamUserToken(), apiRequest.getLocale());
                String title = null == userInfo ? "" : userInfo.getName();
                driveTips.setTitle(title + driveTips.getTitle());
                pageData.put(layout.getSchema(), driveTips);
                layoutList.add(layout);
            }
        }
        uiBotModel.setLayout(layoutList);

        return uiBotModel;
    }
}
