package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.briefingexpress.BriefingExpress;
import com.digiwin.mobile.mobileuibot.core.component.briefingexpress.BriefingExpressData;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtReportData;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

/**
 * <p>功能描述：有工作任务/项目时，首页构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexBuildHasWorkStrategy
 * @Author: Zaregoto
 * @Date: 2022/1/24 22:17
 */
@Slf4j
@Component("indexBuildHasWorkStrategy")
public class IndexBuildHasWorkStrategy implements IndexBuildStrategy {

    private final static String DIGI_WIN_CLOUD = "digiwincloud";

    @Autowired
    private RecommendService recommendService;

    @Autowired
    private DashboardService dashboardService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_HAS_WORK.toString();
    }

    @Override
    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        // TODO pageId异常时，使用INDEX渲染
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator<UiBotLayout> layoutIterator = uiBotModel.getLayout().iterator();
        List<UiBotLayout> layoutList = new ArrayList<>();
        //是否有"为你推荐"
        boolean haveRecommend = false;
        String locale = apiRequest.getLocale();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = layoutIterator.next();
            if (IndexNavBar.COMPONENT_TYPE.equals(layout.getType())
                    && pageData.get(layout.getSchema()) != null) {
                IndexNavBar indexNavBar =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                indexNavBar.initShortcutButton(apiRequest, projectService, localeService);
                pageData.put(layout.getSchema(), indexNavBar);
                layoutList.add(layout);
            } else if (CustomTabController.COMPONENT_TYPE.equals(layout.getType())
                    && pageData.get(layout.getSchema()) != null) {
                CustomTabController customTabController =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()),
                                CustomTabController.class);
                customTabController.getTabItems().forEach(item -> {
                    item.setName(localeService.getLanguageValue(locale, item.getName()));
                    item.setJumpPageTitle(localeService.getLanguageValue(locale, item.getJumpPageTitle()));
                });

                List<CustomTabControllerItem> itemList = new ArrayList<>();

                if (!handleTripartiteToDo(apiRequest, customTabController, itemList)) {
                    customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(),
                            apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                    // 无三方待办权限，移除三方待办
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                if (!hasProjectData) {
                    //当没有项目时，只配置我的任务
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                pageData.put(layout.getSchema(), customTabController);
                layoutList.add(layout);
            } else if (UniSearch.COMPONENT_TYPE.equals(layout.getType())
                    && pageData.get(layout.getSchema()) != null) {
                UniSearch uniSearch = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put(layout.getSchema(), uniSearch);
                layoutList.add(layout);
//            } else if (AppEntrance.COMPONENT_TYPE.equals(layout.getType())) {
//                AppEntrance appEntrance = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), AppEntrance.class);
//                appEntrance.initSetting(apiRequest.getLocale());
//                // 将推荐的应用功能放在最前面
//                appEntrance.getAppList().addAll(0, this.recommendService.getRecommendAppList(apiRequest.getIamUserToken(),
//                        apiRequest.getUserId(), apiRequest.getLocale()));
//                if (!appEntrance.getAppList().isEmpty()) {
//                    pageData.put(layout.getSchema(), appEntrance);
//                    layoutList.add(layout);
//                } else {
//                    // 没有任何应用功能时，删除对应的layout
//                    pageData.remove(layout.getSchema());
//                    layoutIterator.remove();
//                }
            } else if (CustomGroup.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                //为你推荐
                CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                customGroup.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), customGroup.getName()));
                if (customGroup.getContent().getPageData() == null) {
                    customGroup.getContent().setPageData(new UiBotPageData());
                }
                List<UiBotLayout> groupLayoutList = customGroup.getContent().getLayout();
                List<UiBotLayout> newGroupLayoutList = new ArrayList<>();
                for (UiBotLayout groupLayout : groupLayoutList) {
                    if ("recommend_see".equals(groupLayout.getSchema())) {
                        //猜你想看
//                        List<CustomContent> customContentList = dashboardService.generateDashboardCustomContent(apiRequest.getIamUserToken(),
//                                apiRequest.getLocale(), apiRequest.getClientId(), true, true);
//                        if (customContentList != null && !customContentList.isEmpty()) {
//                            customContentList.stream().forEach(customContent -> {
//                                String uuid = UUIDUtil.getUuid();
//                                UiBotLayout customContentLayout = new UiBotLayout();
//                                customContentLayout.setType(CustomContent.COMPONENT_TYPE);
//                                customContentLayout.setSchema(uuid);
//                                newGroupLayoutList.add(customContentLayout);
//                                customGroup.getContent().getPageData().put(uuid, customContent);
//                            });
//                        }
                    } else if ("recommend_do".equals(groupLayout.getSchema())) {
                        //猜你想做
                        List<AppFunctionTouchable> appFunctionTouchableList = this.recommendService.getRecommendAppList(apiRequest);
                        if (!CollectionUtils.isEmpty(appFunctionTouchableList)) {
                            haveRecommend = true;
                            AppEntrance appEntrance = new AppEntrance();
                            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
                            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
                            appEntrance.getAppList().addAll(appFunctionTouchableList);
                            List<AppFunctionTouchable> appList = appEntrance.getAppList();
                            List<AppFunctionTouchable> newAppList = new ArrayList<>(appList.size());
                            for (AppFunctionTouchable app : appList) {
                                if (app.getAction() != null && StringUtils.hasLength(app.getName())) {
                                    newAppList.add(app);
                                }
                            }
                            if (CollectionUtils.isEmpty(newAppList)) {
                                haveRecommend = false;
                            } else {
                                appEntrance.setAppList(newAppList);
                                String schema = UUIDUtil.getUuid();
                                UiBotLayout appLayout = new UiBotLayout();
                                appLayout.setType(AppEntrance.COMPONENT_TYPE);
                                appLayout.setSchema(schema);
                                newGroupLayoutList.add(appLayout);
                                customGroup.getContent().getPageData().put(schema, appEntrance);
                            }
                        }
                        //拥有绿色智机项目权限，新建异步组件
                        if (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset()) {
                            String uuid = UUIDUtil.getUuid();
                            CustomContent customContent = CustomContent.create(apiRequest.getLocale(), apiRequest.getClientId(),
                                    apiRequest.getIamUserToken(), "",
                                    AppContext.getBaseUrl() + "/machine/preset/myBench/queryClickAppJob", true);
                            customContent.getSysParam().put("tenantId", apiRequest.getTenantId());
                            customContent.getSysParam().put("userId", apiRequest.getUserId());
                            UiBotLayout customContentLayout = new UiBotLayout();
                            customContentLayout.setType(CustomContent.COMPONENT_TYPE);
                            customContentLayout.setSchema(uuid);
                            newGroupLayoutList.add(customContentLayout);
                            customGroup.setIsSlide(true);
                            customGroup.getContent().getPageData().put(uuid, customContent);
                        }
                    }
                }
                if (haveRecommend || (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset())) {
                    customGroup.getContent().setLayout(newGroupLayoutList);
                    layoutList.add(layout);
                    pageData.put(layout.getSchema(), customGroup);
                }
            } else if (BlankArea.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                //有为你推荐时，也有"空白组件"
                if (haveRecommend) {
                    layoutList.add(layout);
                }
            } else if (BriefingExpress.COMPONENT_TYPE.equals(layout.getType())) {
                BriefingExpress briefingExpress = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), BriefingExpress.class);
                //查询未读的数据有没有
                Map<String, Object> params = new HashMap<>(1);
                params.put("isRead", false);
                // TODO 首页简报速递在2023-Q4暂不需要，后续需要后再改成从ADT获取
//                List<DigiwinReportData> datas = digiwinAdtProxyService.getReportDataList(
//                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, params);
                /**
                 * mock的json
                 */
                List<DigiwinAdtReportData> datas = ModuleUtils.listToListObject(
                        JsonUtil.jsonStringToObject(FileUtil.readText("static/appstore-use/briefingexpress_report_list.json"), List.class), DigiwinAdtReportData.class);
                //没有未读的数据，那就不需要做处理了
                if (!CollectionUtils.isEmpty(datas)) {
                    briefingExpress.setTitle(localeService.getLanguageValue(locale, briefingExpress.getTitle()));
                    //首页最多显示2条，dataSize作为跳出循环的标志
                    int dataSize = 0;
                    for (DigiwinAdtReportData reportData : datas) {
                        if (dataSize >= 2) {
                            break;
                        }
                        BriefingExpressData data = new BriefingExpressData();
                        data.setContent(reportData.getTitle());
                        data.setAction(Action.createExpressButton(reportData));
                        data.setStatus(reportData.getStatus());
                        data.setUnRead(reportData.getReadCount() == 0);
                        briefingExpress.getDatas().add(data);
                        dataSize++;
                    }
                    briefingExpress.setSubTitle(briefingExpress, datas.size(), locale, localeService);
                    if (datas.size() > briefingExpress.getShowDataNum()) {
                        briefingExpress.setHasShowMore(true);
                        briefingExpress.setShowMoreText(localeService.getLanguageValue(locale, briefingExpress.getShowMoreText()));
                    }
                    layoutList.add(layout);
                    pageData.put(layout.getSchema(), briefingExpress);
                }
            }
        }
        uiBotModel.setLayout(layoutList);

        return uiBotModel;
    }

    /**
     * 校验简报速递数据是否存在未读的
     *
     * @param datas
     * @return
     */
    private Boolean checkData(List<DigiwinAdtReportData> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return false;
        } else {
            for (DigiwinAdtReportData reportData : datas) {
                if (reportData.getReadCount() == 0) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * 处理三方待办首页信息
     *
     * @param apiRequest
     * @param customTabController
     * @param itemList
     */
    private Boolean handleTripartiteToDo(ApiRequest apiRequest, CustomTabController customTabController, List<CustomTabControllerItem> itemList) {
        try {
            // 检查是否有三方待办权限
            boolean hasPermission = CompletableFuture.supplyAsync(() ->
                            this.digiwinSemcProxyService.queryStatus(apiRequest.getClientId(),
                                    apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), this.threadPoolTaskExecutor)
                    .get();
            if (hasPermission) {
                List<LabelSystemData> tripartiteTodoList = CompletableFuture.supplyAsync(() ->
                                this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(),
                                        apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), this.threadPoolTaskExecutor)
                        .get();
                customTabController.updateAsyncTripartiteToDoConfigParam(apiRequest.getIamUserToken(),
                        apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), tripartiteTodoList);
                // 如果是地端，只显示三方待办
                if (!AppContext.getApiUrlSetting().getSemcUrl().contains(DIGI_WIN_CLOUD)) {
                    List<CustomTabControllerItem> newItemList = customTabController.getTabItems().stream()
                            .filter(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId()))
                            .collect(Collectors.toList());
                    customTabController.setTabItems(newItemList);
                } else if (CollectionUtils.isEmpty(tripartiteTodoList)) {
                    // 如果非地端且没有三方待办，则不显示三方待办
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                return true;
            }
        } catch (InterruptedException e) {
            log.error("异步处理三方待办首页信息被中断: {}", e.getMessage(), e);
        } catch (ExecutionException e) {
            log.error("异步处理三方待办首页信息异常: {}", e.getCause() != null ? e.getCause().getMessage() : e.getMessage(), e);
        } catch (Exception e) { // 捕获其他可能的异常
            log.error("处理三方待办首页信息时发生异常: {}", e.getMessage(), e);
        }
        return false;
    }

}