package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 无租户账号首页(目前跟游客模式首页完全一样)
 *
 * @author zhangjj
 * @date 2022/9/15 11:27
 */
@Component
public class IndexBuildNoTenantStrategy {

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        //为做多语言
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!CollectionUtils.isEmpty(layoutList)) {
            layoutList.forEach(layout -> {
                switch (layout.getType()) {
                    case IndexNavBar.COMPONENT_TYPE:
                        IndexNavBar indexNavBar = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                        indexNavBar.initSetting(apiRequest.getLocale(), null);
                        pageData.put(layout.getSchema(), indexNavBar);
                        break;
                    case CustomGroup.COMPONENT_TYPE:
                        CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                        customGroup.initSetting(apiRequest.getLocale());
                        pageData.put(layout.getSchema(), customGroup);
                        break;
                    case BlankArea
                            .COMPONENT_TYPE:
                        BlankArea blankArea = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), BlankArea.class);
                        pageData.put(layout.getSchema(), blankArea);
                        break;
                    case Swiper.COMPONENT_TYPE:
                        Swiper swiper = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Swiper.class);
                        swiper.initSetting(apiRequest.getLocale());
                        pageData.put(layout.getSchema(), swiper);
                        break;
                    case CustomTabController.COMPONENT_TYPE:
                        CustomTabController customTabController =
                                JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()),
                                        CustomTabController.class);
                        customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(),
                                apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                        CustomTabControllerItem controllerItem = customTabController.getTabItems().get(0);
                        controllerItem.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), controllerItem.getJumpPageTitle()));
                        controllerItem.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), controllerItem.getName()));
                        List<CustomTabControllerItem> itemList = new ArrayList<>();
                        //当没有项目时，只配置我的任务
                        itemList = customTabController.getTabItems().stream().filter(
                                item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId())
                        ).collect(Collectors.toList());
                        customTabController.setTabItems(itemList);
                        pageData.put(layout.getSchema(), customTabController);
                        break;
                    default:
                        break;
                }
            });
        }
        return uiBotModel;
    }
}
