package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.Image;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>功能描述：无工作任务/项目时，首页构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexBuildNoWorkStrategy
 * @Author: Zaregoto
 * @Date: 2022/1/24 22:05
 */
@Component("indexBuildNoWorkStrategy")
public class IndexBuildNoWorkStrategy implements IndexBuildStrategy {

    @Autowired
    private RecommendService recommendService;

    @Autowired
    private DashboardService dashboardService;

    @Override
    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_NO_WORK.toString();
    }

    @Override
    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        // TODO pageId异常时，使用INDEX渲染
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator<UiBotLayout> layoutIterator = uiBotModel.getLayout().iterator();
        List<UiBotLayout> layoutList = new ArrayList<>();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = layoutIterator.next();
            if (layout.getType().equals(IndexNavBar.COMPONENT_TYPE)
                    && pageData.get(layout.getSchema()) != null) {
                IndexNavBar indexNavBar =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                pageData.put(layout.getSchema(), indexNavBar);
                layoutList.add(layout);
            } else if (layout.getType().equals(BlankArea.COMPONENT_TYPE)) {
                layoutList.add(layout);
                // 暂无处理，预留空
            } else if (layout.getType().equals(CustomTabController.COMPONENT_TYPE)
                    && pageData.get(layout.getSchema()) != null) {
                CustomTabController customTabController =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()),
                                CustomTabController.class);
                customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(),
                        apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                pageData.put(layout.getSchema(), customTabController);
                layoutList.add(layout);
            } else if (layout.getType().equals(Image.COMPONENT_TYPE)
                    && pageData.get(layout.getSchema()) != null) {
                Image image = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Image.class);

                Integer dataType = image.getContent().getDataType();
                if (BaseImageContentDataTypeEnum.NETWORK_HTTP_URL.getValue().equals(dataType)) {
                    //替换参数中的${locale}
                    String data = image.getContent().getData();
                    image.getContent().setData(data.replace("${locale}", apiRequest.getLocale()));
                }
                pageData.put(layout.getSchema(), image);
                layoutList.add(layout);
                // 暂无处理，预留空
            } else if (layout.getType().equals(UniSearch.COMPONENT_TYPE)
                    && pageData.get(layout.getSchema()) != null) {
                UniSearch uniSearch = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put(layout.getSchema(), uniSearch);
                layoutList.add(layout);
//            } else if (layout.getType().equals(AppPlayground.COMPONENT_TYPE)
//                    && pageData.get(layout.getSchema()) != null) {
//                AppPlayground appPlayground = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), AppPlayground.class);
//                appPlayground.initSetting(apiRequest.getLocale());
//                // 将推荐的应用功能入口列表放在最前面
//                appPlayground.getAppList().addAll(0, this.recommendService.getRecommendAppList(apiRequest.getIamUserToken(),
//                        apiRequest.getUserId(), apiRequest.getLocale()));
//                if (!appPlayground.getAppList().isEmpty()) {
//                    pageData.put(layout.getSchema(), appPlayground);
//                    layoutList.add(layout);
//                } else {
//                    // 没有任何应用功能时，删除对应的layout
//                    pageData.remove(layout.getSchema());
//                    layoutIterator.remove();
//                }
            } else if ("recommend_see".equals(layout.getType())) {
                //猜你想看
                List<CustomContent> customContentList = dashboardService.generateDashboardCustomContent(apiRequest.getIamUserToken(),
                        apiRequest.getLocale(), apiRequest.getClientId(), true, true);
                if (customContentList != null && !customContentList.isEmpty()) {
                    customContentList.stream().forEach(customContent -> {
                        String uuid = UUIDUtil.getUuid();
                        UiBotLayout customContentLayout = new UiBotLayout();
                        customContentLayout.setType(CustomContent.COMPONENT_TYPE);
                        customContentLayout.setSchema(uuid);
                        layoutList.add(customContentLayout);
                        pageData.put(uuid, customContent);
                    });
                }
            } else if ("recommend_do".equals(layout.getType())) {
                //猜你想做
                CustomContent customContent = CustomContent.create(apiRequest.getLocale(), apiRequest.getClientId(),
                        apiRequest.getIamUserToken(), "",
                        AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/recommend/menu?userId=" + apiRequest.getUserId(), true);
                String uuid = UUIDUtil.getUuid();
                UiBotLayout customContentLayout = new UiBotLayout();
                customContentLayout.setType(CustomContent.COMPONENT_TYPE);
                customContentLayout.setSchema(uuid);
                layoutList.add(customContentLayout);
                pageData.put(uuid, customContent);
            }
        }
        uiBotModel.setLayout(layoutList);
        return uiBotModel;
    }
}
