package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.index.NonSuperAdminTips;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Iterator;

/**
 * <p>功能描述：员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控 首页画面，首页构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexBuildDriverNoVehicleZtbStrategy
 * @Author: Zaregoto
 * @Date: 2022/1/24 22:17
 */
@Component("indexBuildNonSuperAdminNotSetAccountStrategy")
public class IndexBuildNonSuperAdminNotSetAccountStrategy {

    @Autowired
    private ProjectService projectService;

    @Autowired
    private LocaleService localeService;

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator<UiBotLayout> layoutIterator = uiBotModel.getLayout().iterator();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = layoutIterator.next();
            switch (layout.getType()) {
                case IndexNavBar.COMPONENT_TYPE:
                    IndexNavBar indexNavBar =
                            JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                    indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                    indexNavBar.initShortcutButton(apiRequest, projectService, localeService);
                    pageData.put(layout.getSchema(), indexNavBar);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea blankArea = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), BlankArea.class);
                    pageData.put(layout.getSchema(), blankArea);
                    break;
                case NonSuperAdminTips.COMPONENT_TYPE:
                    NonSuperAdminTips nonSuperAdminTips = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), NonSuperAdminTips.class);
                    nonSuperAdminTips.initSetting(localeService, locale, apiRequest.getRawData());
                    pageData.put(layout.getSchema(), nonSuperAdminTips);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
