package com.digiwin.mobile.mobileuibot.index;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：首页生成策略工厂类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2022/1/24 21:51
 */
@Component("indexBuildStrategyFactory")
public class IndexBuildStrategyFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, IndexBuildStrategy> INDEX_BUILD_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public IndexBuildStrategy get(String key) {
        return INDEX_BUILD_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 IndexBuildStrategy 注册到 INDEX_BUILD_MAP
        this.appContext.getBeansOfType(IndexBuildStrategy.class).values().forEach(
            strategy -> INDEX_BUILD_MAP.put(strategy.getIndexType(), strategy));
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
