package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 游客模式首页
 *
 * @author zhangjj
 * @date 2022/8/26 11:27
 */
@Component
public class IndexBuildTouristModeStrategy {

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        //为做多语言
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!CollectionUtils.isEmpty(layoutList)) {
            layoutList.forEach(layout -> {
                switch (layout.getType()) {
                    case IndexNavBar.COMPONENT_TYPE:
                        IndexNavBar indexNavBar = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), IndexNavBar.class);
                        indexNavBar.initSetting(apiRequest.getLocale(), null);
                        pageData.put(layout.getSchema(), indexNavBar);
                        break;
                    case CustomGroup.COMPONENT_TYPE:
                        CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                        customGroup.initSetting(apiRequest.getLocale());
                        pageData.put(layout.getSchema(), customGroup);
                        break;
                    case Swiper.COMPONENT_TYPE:
                        Swiper swiper = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Swiper.class);
                        swiper.initSetting(apiRequest.getLocale());
                        // 判断是否台湾还是大陆 区  如果是台湾区，过滤在途宝司机注册轮播图
                        Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
                        if (isTw) {
                            List<BaseImageContent> contents = swiper.getContent().stream()
                                    .filter(content -> !BaseImageContentCategoryEnum.ZTB_DRIVER_REGISTER.getValue().equals(content.getCategory()))
                                    .collect(Collectors.toList());
                            swiper.setContent(contents);
                        }
                        for (BaseImageContent content : swiper.getContent()) {
                            if (BaseImageContentCategoryEnum.ZTB_DRIVER_REGISTER.getValue().equals(content.getCategory())) {
                                Action action = content.getAction();
                                if (null != action) {
                                    Map<String, Object> params = new HashMap<>(1);
                                    params.put("module_type", "1");
                                    String webUrl = digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(),
                                            apiRequest.getTenantId(), apiRequest.getLocale(), params);
                                    if (StringUtil.isNotEmpty(webUrl)) {
                                        action.setRequestUrl(webUrl);
                                    }
                                }
                            }
                        }
                        pageData.put(layout.getSchema(), swiper);
                        break;
                    default:
                        break;
                }
            });
        }
        return uiBotModel;
    }
}