package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.auxiliary.AuxiliaryLine;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.BusinessComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.BusinessImage;
import com.digiwin.mobile.mobileuibot.core.component.h5link.H5Link;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.*;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.Ball;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.BallRouter;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.Dinstrict;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.ToolBar;
import com.digiwin.mobile.mobileuibot.core.component.news.News;
import com.digiwin.mobile.mobileuibot.core.component.picture.PictureComponent;
import com.digiwin.mobile.mobileuibot.core.component.picture.PictureHotZone;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncConfig;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.PortalTitle;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.TitleColor;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.TitleStyle;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.UiBotModelBuildDashboardV2Strategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum.*;

/***
 * 移动端门户配置，V2首页构建策略
 */
@Slf4j
@Component("indexPortalBuildStrategy")
public class IndexPortalBuildStrategy implements IndexBuildStrategy {

    private final static String DIGI_WIN_CLOUD = "digiwincloud";

    private final static String PROJECT = "INDEX-MY_WORKSPACE-CARD_LIST";

    private final static String TASK = "INDEX-MY_WORKSPACE-TODO_LIST";

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private BallRouter ballRouter;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private PortalService portalService;

    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;


    @Autowired
    private UiBotModelBuildDashboardV2Strategy uiBotModelBuildDashboardV2Strategy;

    @Override
    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_PORTAL.toString();
    }

    /**
     * 布局生产
     *
     * @param apiRequest
     * @param pageSetting
     * @param hasProjectData
     * @return
     */
    @Override
    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        // 返回的mode
        UiBotRenderData renderData = UiBotRenderData.createEmptyRenderData();
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = new ArrayList<>();
        renderData.setBody(body);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.setRenderData(renderData);
        uiBotModel.setRenderVersion(2);

        UserPortalInfoRequest req = new UserPortalInfoRequest()
                .setId(Long.valueOf(apiRequest.getDataId()))
                .setClientType(1)
                .setPortalTypeSource(Optional.ofNullable(apiRequest.getRawData()).map(x -> x.getInteger("portalTypeSource")).orElse(0))
                .setScene(Optional.ofNullable(apiRequest.getRawData()).map(x -> x.getInteger("scene")).orElse(0))
                .setPortalType(Optional.ofNullable(apiRequest.getRawData()).map(x -> x.getInteger("portalType")).orElse(0));
        // 调用semc服务查询门户内容
        MobilePortalInfoResp mobilePortalInfo = digiwinSemcProxyService.getMobilePortalInfo(apiRequest.getLocale(), apiRequest.getIamUserToken(), req);
        if (!ObjectUtils.isEmpty(mobilePortalInfo) && StringUtils.hasText(mobilePortalInfo.getRecentlyMsg())) {
            String msg = localeService.getLanguageValue(apiRequest.getLocale(), mobilePortalInfo.getRecentlyMsg());
            throw new ServiceException(msg);
        }
        List<MobilePortalInfoContentResp> mobilePortalInfoContentRespList = new ArrayList<>();
        if (!ObjectUtils.isEmpty(mobilePortalInfo) && !CollectionUtils.isEmpty(mobilePortalInfo.getContentList())) {
            mobilePortalInfoContentRespList = mobilePortalInfo.getContentList();
        }

        // 按业务字段的渲染组件类型分组
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> uiBotModelLayout = uiBotModel.getLayout();
        Map<String, UiBotLayout> mobileComponentMap = uiBotModelLayout.stream()
                .filter(x -> pageData.get(x.getSchema()) != null).collect(Collectors.toMap(UiBotLayout::getType, Function.identity(), (a, b) -> a));


        //如果是门户布局需要生成导航
        if (null != mobilePortalInfo.getPortalType() &&
                mobilePortalInfo.getPortalType().equals(PortalConstans.MobilePortalTypeEnum.PORTAL.getFlag())) {
            //首部导航生成  IndexNavrBar
            buildIndexNavBar(mobileComponentMap,body,pageData,apiRequest,mobilePortalInfo);
        }
        //自定义页面设置二级页面标题和背景色
        if (null != mobilePortalInfo.getPortalType() &&
                mobilePortalInfo.getPortalType().equals(PortalConstans.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
            uiBotModel.setPageTitle(mobilePortalInfo.getTitle());
            uiBotModel.setPageBackgroudColor(mobilePortalInfo.getBgColor());
        }

        //增加过滤空的自定义金刚区逻辑
        List<MobilePortalInfoContentResp> mobilePortalInfoContentRespsNew = new ArrayList<>();
        List<MobilePortalInfoContentResp> kingKongList = mobilePortalInfoContentRespList.stream()
                .filter(x -> {
                    if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                        PortalContentKingKongDistrict district = JsonUtil.jsonStringToObject(x.getContentAttr(), PortalContentKingKongDistrict.class);
                        return district != null && PortalConstans.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(district.getCustomType());
                    }
                    return false;
                })
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(kingKongList)) {

            List<MobilePortalInfoContentResp> kingKongNullList = kingKongList.stream()
                    .filter(x -> {
                        if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                            PortalContentKingKongDistrict district = JsonUtil.jsonStringToObject(x.getContentAttr(), PortalContentKingKongDistrict.class);
                            return district == null || CollectionUtils.isEmpty(district.getBallList());
                        }
                        return true;
                    }).collect(Collectors.toList());
            //拥有空的栏目
            if (!CollectionUtils.isEmpty(kingKongNullList)) {
                //全部为空栏位
                if (kingKongNullList.size() == kingKongList.size()) {
                    boolean hasNull = false;
                    for (MobilePortalInfoContentResp contentResp : mobilePortalInfoContentRespList) {
                        List<PortalContentKingKongDistrictBall> ballList = new ArrayList<>();
                        Integer customType = 0;
                        if (contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                            PortalContentKingKongDistrict district = JsonUtil.jsonStringToObject(contentResp.getContentAttr(), PortalContentKingKongDistrict.class);
                            if (district != null) {
                                ballList = district.getBallList();
                                customType = district.getCustomType();
                            }
                        }
                        //如果为自定义金刚区且未加入过空栏目，则新增加入一笔
                        if (contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())
                                && CollectionUtils.isEmpty(ballList) && !hasNull) {
                            MobilePortalInfoContentResp mobilePortalInfoContentResp = new MobilePortalInfoContentResp();
                            mobilePortalInfoContentResp.setContentType(0);
                            PortalContentKingKongDistrict district = new PortalContentKingKongDistrict();
                            district.setCustomType(1);
                            mobilePortalInfoContentResp.setContentAttr(JsonUtil.javaObjectToJsonString(district));
                            mobilePortalInfoContentRespsNew.add(mobilePortalInfoContentResp);
                            hasNull = true;
                        }
                        //不为自定义金刚区，则直接新增
                        if (!contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                            mobilePortalInfoContentRespsNew.add(contentResp);
                        }

                        //为自定义金刚区，且为租户自定义金刚区则直接新增
                        if (contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue()) && PortalConstans.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(customType)) {
                            mobilePortalInfoContentRespsNew.add(contentResp);
                        }
                    }
                } else {
                    //非全部空栏目，则过滤空栏目直接赋值
                    mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList.stream()
                            .filter(x -> {
                                if (!x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                                    return true;
                                }
                                PortalContentKingKongDistrict district = JsonUtil.jsonStringToObject(x.getContentAttr(), PortalContentKingKongDistrict.class);
                                return district == null || !CollectionUtils.isEmpty(district.getBallList());
                            }).collect(Collectors.toList());
                }
            } else {
                mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList;
            }
        } else {
            mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList;
        }

        // 构建各组件内容
        mobilePortalInfoContentRespsNew.forEach(x -> {
            // 任务
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_TASK.getValue())) {
                CustomTabControllerItem taskItem = buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.PRE_TASK.getValue());
                setProjectAndTask(taskItem, body);
            }
            // 项目追组
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_PROJECT.getValue())) {
                CustomTabControllerItem projectItem = buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.PRE_PROJECT.getValue());
                setProjectAndTask(projectItem, body);
            }
            // 三方待办
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue())) {
                CustomTabControllerItem thirdTodoItem = buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue());
                setProjectAndTask(thirdTodoItem, body);
            }
            // 金刚球在管理后台已经组装好到金刚区
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                setKingKongDistrictAndBall(body, x, apiRequest);
            }
            // 轮播图
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_CAROUSEL.getValue())) {
                setCarouselImageModule(body, x, apiRequest);
            }
            // 公告
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_NEWS.getValue())) {
                setNewsModule(body, x, apiRequest);
            }
            // 分割线
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.DIVIDER.getValue())) {
                setDividerInfo(body, x);
            }
            //标题组件
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.TITLE.getValue())) {
                setTitleInfoModule(body, x, apiRequest);
            }
            //图片组件
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PICTURE.getValue())) {
                setPictureModule(body, x, apiRequest);
            }
            //业务入口组件
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.BUSINESS_ENTRANCE.getValue())) {
                setBusinessModule(body, x, apiRequest);
            }
            // H5外链
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.H5_LINK.getValue())) {
                setH5LinkModule(body, x, apiRequest);
            }
            //首页自定义
            StopWatch stopWatch1 = new StopWatch();
            stopWatch1.start();
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.USER_CUSTOM_CONTAINER.getValue())){
                setUserCustomModel(body,x,apiRequest);
            }
            stopWatch1.stop();
            log.info("总消耗时间:{}",stopWatch1.getTotalTimeMillis());
        });
        uiBotModel.setPageData(new UiBotPageData());
        uiBotModel.setLayout(new ArrayList<>());
        return uiBotModel;
    }

    private void setH5LinkModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp x, ApiRequest apiRequest) {
        H5Link h5Link = new H5Link();
        body.add(new BaseMobileComponentWrapper<>(h5Link, "DW_" + h5Link.returnComponentType()));

        h5Link.setTitle(x.getContentName());
        h5Link.setLabelTypeSource(x.getLabelTypeSource());
        h5Link.setContentConfig(JsonUtil.jsonStringToObject(x.getContentAttr(), new TypeReference<HashMap<String, Object>>() {
        }));
    }

    /**
     * 首页自定义组件
     * @param body
     * @param x
     * @param apiRequest
     */
    private void setUserCustomModel(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp x, ApiRequest apiRequest) {
        UserCustomContainer userCustomContainerComponent = new UserCustomContainer();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(userCustomContainerComponent);
        componentWrapper.setComponentType("DW_"+ userCustomContainerComponent.returnComponentType());
        List<AppStructure> content = new ArrayList<>();
        userCustomContainerComponent.setContent(content);
        body.add(componentWrapper);
        ApiRequsetPortal apiRequsetPortal = new ApiRequsetPortal();
        apiRequsetPortal.setIsAll(true);
        apiRequsetPortal.setLocale(apiRequest.getLocale());
        apiRequsetPortal.setIamUserToken(apiRequest.getIamUserToken());
        //从semc获取栏目
        List<ApplicationColumnReq> list = semcProxyService.getApplicationColumnListNew(apiRequsetPortal);
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        //遍历栏目生成userCustomContainerComponent的子组件
        //过滤出为栏目的对象集合
        List<ApplicationColumnReq> collect = list.stream().filter(e -> Objects.isNull(e.getParentId())).filter(e -> !Objects.equals(0,e.getStatus())).collect(Collectors.toList());
        Set set = new HashSet();
        for (ApplicationColumnReq applicationColumnReq : collect){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            if (!CollectionUtils.isEmpty(idAndSources)){
                for (Map map : idAndSources){
                    Integer source = MapUtils.getInteger(map, "source", null);
                    if (Objects.nonNull(source)) {
                        set.add(source);
                    }
                }
            }
        }
        //获取semc配置的应用
        List<MobileClassificatonResp> classificatonRespList = new ArrayList<>();
        if (set.contains(0)) {
            classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        }
        //获取报表应用
        List<AppResp> reportList = new ArrayList<>();
        if (set.contains(1)) {
            reportList = portalService.getReportList(apiRequest);
        }
        //获取手动发起项目
        List<LaunchableProject> accessibleLaunchableProjectList =
                this.projectService.getLaunchableProjectList(apiRequsetPortal.getIamUserToken(), apiRequsetPortal.getTenantId(), apiRequsetPortal.getLocale());
        //获取数据录入的数据
        List<DigiwinAtmcTmData> basicDataList = audcProxyService.getBasicDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        //获取智能入口的数据
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty(reportList)){
            hasReportModule = true;
        }
        List<AppModuleItem> intelligentEnterAppModuleItemList = uiBotModelBuildDashboardV2Strategy.getIntelligentEnterAppModuleItemList(apiRequest, hasReportModule);
        //获取绿色智机的数据
        List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(new ArrayList<>(), apiRequest.getLocale(), apiRequest.getIamUserToken());
        for (ApplicationColumnReq applicationColumnReq : collect){
            //得到栏目下的应用
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            AppStructure appStructure = new AppStructure();
            appStructure.setTitle(applicationColumnReq.getName());
            appStructure.setIsShowName(applicationColumnReq.getIsNameShow());
            appStructure.setId(applicationColumnReq.getId());
            List<SampleApp> sampleAppList = Lists.newArrayList();
            for (Map applicationColumnReq1 : idAndSources){
                String id = MapUtils.getString(applicationColumnReq1, "id", null);
                Integer source = MapUtils.getInteger(applicationColumnReq1, "source", null);
                String moduleId = MapUtils.getString(applicationColumnReq1, "moduleId", null);
                if (source == 0){
                    for (MobileClassificatonResp classificatonResp : classificatonRespList) {
                        //如果分类下作业为空，则不组装
                        if (CollectionUtils.isEmpty(classificatonResp.getMobileCustomAppList())) {
                            continue;
                        }
                        for (MobileDatasourceInfoResp customApp : classificatonResp.getMobileCustomAppList()) {
                            if (String.valueOf(customApp.getId()).equals(id)) {
                                MobileBallResp mobileBallResp = new MobileBallResp();
                                mobileBallResp.setCustomApplicationId(customApp.getId());
                                mobileBallResp.setCallBackUrl("");
                                mobileBallResp.setBallName("");
                                Action action = ballRouter.getCompoentAction(PortalConstans.CUSTOM_APPLICATION, apiRequest, mobileBallResp);
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(customApp.getIcon());
                                sampleApp.setName(customApp.getName());
                                sampleApp.setAction(action);
                                sampleAppList.add(sampleApp);
                            }
                        }
                    }
                }
                //&& moduleId.equals(ReportCategoryEnum.STATEMENT.getValue())
                if (source == 1){
                    for (AppResp appResp : reportList){
                        if (CollectionUtils.isEmpty(appResp.getAppRespSamplList())){
                            continue;
                        }
                        for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                            if (appRespSampl.getId().equals(id) && ReportCategoryEnum.STATEMENT.getValue().equals(appRespSampl.getCategory())){
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(appRespSampl.getIcon());
                                sampleApp.setName(appRespSampl.getName());
                                Action action = new Action();
                                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                                action.setRequestUrl(BottomButtonDigiwinAthena.buildTbbH5Url(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),appRespSampl.getId(), appRespSampl.getName()));
                                sampleApp.setAction(action);
                                sampleAppList.add(sampleApp);
                            }else{
                                continue;
                            }
                        }
                    }
                }
                if (source == 2){
                    if (CollectionUtils.isEmpty(accessibleLaunchableProjectList)) {
                        continue;
                    }
                    for (LaunchableProject launchableProject : accessibleLaunchableProjectList){
                            if (launchableProject.getCode().equals(id)){
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(null);
                                //处理智慧检料名字
                                if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(launchableProject.getCode())) {
                                    sampleApp.setName(launchableProject.getName().substring(0, 4));
                                } else {
                                    sampleApp.setName(launchableProject.getName());
                                }
                                Action<Map<String, Object>> action = new Action<>();
                                // 发起项目设计器跳转需要的信息
                                if (BooleanUtils.isTrue(launchableProject.getIsDesigner())) {
                                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                                    action.setJumpPageTitle(launchableProject.getName());
                                    Map<String, Object> rawData = new HashMap<>(2);
                                    rawData.put("project_introduce", launchableProject.getDesc());
                                    rawData.put("project_name", launchableProject.getName());
                                    rawData.put("dataId", launchableProject.getCreateSuffix());
                                    action.setRawData(rawData);
                                } else {
                                    if ("scan_freightage_start".equalsIgnoreCase(launchableProject.getCode())) {
                                        Action rawDataAction = new Action();
                                        rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                                        rawDataAction.setJumpPageTitle(launchableProject.getName());
                                        rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                                        rawDataAction.setDataId(launchableProject.getCreateSuffix());
                                        Map<String, Object> rawData = new HashMap<>(2);
                                        rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                                        rawData.put("action", rawDataAction);
                                        action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                                        action.setRawData(rawData);
                                    } else {
                                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                                        action.setJumpPageTitle(launchableProject.getName());
                                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                                        action.setDataId(launchableProject.getCreateSuffix());
                                    }
                                }
                                sampleApp.setAction(action);
                                sampleAppList.add(sampleApp);
                            }
                    }
                }
                if (source == 3){
                    if (CollectionUtils.isEmpty(basicDataList)) {
                        continue;
                    }
                    String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
                    // 获取type为数据录入的数据
                    List<String> tmActivityIdList = activityFilterService
                            .findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), apiRequest.getTenantId(), tenantVersion)
                            .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(tmActivityIdList)) {
                        continue;
                    }
                    for (DigiwinAtmcTmData digiwinAtmcTmData : basicDataList) {
                        for (DigiwinAtmcTmDataReport digiwinAtmcTmDataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                            if (id.equals(digiwinAtmcTmDataReport.getCode())) {
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(digiwinAtmcTmDataReport.getIcon());
                                sampleApp.setName(digiwinAtmcTmDataReport.getName());
                                Action<?> action = new Action<>();

                                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                                if ("SIGN-DOCUMENT".equals(digiwinAtmcTmDataReport.getCategory())) {
                                    // 单档多栏(模型驱动)
                                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                                } else if (Lists.newArrayList("DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI").contains(digiwinAtmcTmDataReport.getCategory())) {
                                    // 单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动)
                                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                                } else {
                                    // 不存在，返回
                                    return;
                                }
                                action.setJumpPageTitle(digiwinAtmcTmDataReport.getName());
                                action.setDataId(digiwinAtmcTmDataReport.getCode());
                                sampleApp.setAction(action);
                                sampleAppList.add(sampleApp);
                            }
                        }
                    }
                }
                if (source == 4) {
                    if (!CollectionUtils.isEmpty(intelligentEnterAppModuleItemList)){
                        for (AppModuleItem appModuleItem : intelligentEnterAppModuleItemList) {
                            if (id.equals(appModuleItem.getId())) {
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(appModuleItem.getImageUrl());
                                sampleApp.setName(appModuleItem.getName());
                                sampleApp.setAction(appModuleItem.getAction());
                                sampleAppList.add(sampleApp);
                            }
                        }
                    }
                }
                if (source == 5){
                    for (TopicPresetResp topicPresetResp : topicPresetRespList){
                        if (CollectionUtils.isEmpty(topicPresetResp.getTopicpList())){
                            continue;
                        }
                        for (TopicPresetJobResp topicPresetJobResp : topicPresetResp.getTopicpList()){
                            if (id.equals(topicPresetJobResp.getCaseId())) {
                                SampleApp sampleApp = new SampleApp();
                                sampleApp.setIcon(topicPresetJobResp.getTopicPresetIcon());
                                sampleApp.setName(topicPresetJobResp.getTopicPresetName());
                                Action action = new Action();
                                action.setOpenWebPageTitle(topicPresetJobResp.getTopicPresetName());
                                //跳转url
                                action.setRequestUrl(topicPresetJobResp.getTopicPresetUrl());
                                //跳转类型-webview
                                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                                //如果没有设置公司别和厂别，给出提示
                                if (!topicPresetJobResp.getIsSetCompany()) {
                                    action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                                    action.setToastMsg(localeService.getLanguageValue(apiRequest.getLocale(), "请先设置公司别和厂别"));
                                }
                                sampleApp.setAction(action);
                                sampleAppList.add(sampleApp);
                            }
                        }
                    }
                }
            }
            appStructure.setChildren(sampleAppList);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(appStructure.getChildren())) {
                content.add(appStructure);
            }
        }
    }

    /**
     * 生成NavBar组件
     *
     * @param mobileComponentMap 组件信息
     * @param body
     * @param pageData
     * @param apiRequest
     */
    private void buildIndexNavBar(Map<String, UiBotLayout> mobileComponentMap, List<BaseMobileComponentWrapper<BaseMobileComponent>> body, UiBotPageData pageData, ApiRequest apiRequest,MobilePortalInfoResp mobilePortalInfo) {
        if (mobileComponentMap.containsKey(IndexNavBar.COMPONENT_TYPE)) {
            UiBotLayout navBarComponent = mobileComponentMap.get(IndexNavBar.COMPONENT_TYPE);
            IndexNavBar indexNavBar = JsonUtil.objectToJavaObject(pageData.get(navBarComponent.getSchema()), IndexNavBar.class);
            if (0 == mobilePortalInfo.getVersionDefault()) {
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                if (!TestController.specialHandleSwitch()) {
                    indexNavBar.initShortcutButton(apiRequest, projectService, localeService);
                }
                indexNavBar.setCmptVersion(2);
                BaseMobileComponentWrapper<BaseMobileComponent> navBarWrapper = new BaseMobileComponentWrapper<>(indexNavBar);
                navBarWrapper.setComponentType("DW_" + IndexNavBar.COMPONENT_TYPE);
                body.add(navBarWrapper);
            }
            if (1 == mobilePortalInfo.getVersionDefault()){
                ToolBar toolBar = new ToolBar();
                toolBar.setCmptVersion(2);
                toolBar.setSchema(toolBar.getCmptUuid());
                toolBar.setTitle(localeService.getLanguageValue(apiRequest.getLocale(),"首页"));
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                UniSearch uniSearch = indexNavBar.getUniSearch();
                List<Map> rightActions = new ArrayList<>();
                Map map = new HashMap();
                map.put("icon","0xea29");
                map.put("title","搜索");
                map.put("iconType","iconfont");
                Action action = new Action();
                action.setType(11);
                action.setJumpPageId("APP_SEARCH");
                Map mapUniSearch = Maps.newHashMap();
                mapUniSearch.put("uniSearch",uniSearch);
                action.setRawData(mapUniSearch);
                map.put("action",action);
                Map map1 = new HashMap();
                map1.put("icon","0xe6df");
                map1.put("title","扫码");
                map1.put("iconType","iconfont");
                Action action1 = new Action();
                action1.setType(21);
                map1.put("action",action1);
                rightActions.add(map);
                rightActions.add(map1);
                toolBar.setRightActions(rightActions);
                BaseMobileComponentWrapper<BaseMobileComponent> navBarWrapper = new BaseMobileComponentWrapper<>(toolBar);
                navBarWrapper.setComponentType("DW_" + ToolBar.COMPONENT_TYPE);
                navBarWrapper.setSchema(toolBar.getCmptUuid());
                body.add(navBarWrapper);
            }
        }
    }

    /**
     * 生成金刚区/金刚球
     *
     * @param body
     * @param districtInfo
     */
    private void setKingKongDistrictAndBall(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        Dinstrict dinstrict = new Dinstrict();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(dinstrict);
        componentWrapper.setComponentType("DW_" + dinstrict.returnComponentType());
        body.add(componentWrapper);

        PortalContentKingKongDistrict district = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), PortalContentKingKongDistrict.class);

        // 封装金刚区内容
        buildCustomGroup(dinstrict, districtInfo, district);
        List<Ball> balls = new ArrayList<>();
        //金刚球组装到金刚区
        List<PortalContentKingKongDistrictBall> ballList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(district.getBallList())) {
            ballList = district.getBallList();
        }
        //组装金刚球中的action
        for (PortalContentKingKongDistrictBall ballResp : ballList) {
            Ball ball = new Ball();
            ball.setIcon(ballResp.getIconUrl());
            ball.setName(localeService.getLanguageValue(apiRequest.getLocale(), ballResp.getBallName()));
            ball.setType(ballResp.getJumpType());
            //组装跳转action
            Action action = packageComponetAction(ballResp.getJumpType(), ballResp.getJumpTarget(), ballResp.getCustomApplicationId(), apiRequest);
            ball.setActionEvent(action);
            balls.add(ball);
        }
        dinstrict.setComponentsData(balls);
    }

    /**
     * 构建任务/项目追踪/三方待办数据
     *
     * @param mobileComponentMap 组件信息
     * @param pageData           uibot的数据模型
     * @param apiRequest         请求参数
     */
    private CustomTabControllerItem buildTaskAndProject(Map<String, UiBotLayout> mobileComponentMap, UiBotPageData pageData, ApiRequest apiRequest, Integer type) {
        if (mobileComponentMap.containsKey(CustomTabController.COMPONENT_TYPE)) {
            UiBotLayout customLayout = mobileComponentMap.get(CustomTabController.COMPONENT_TYPE);

            // 根据pageData来生成相关数据
            CustomTabController customTabController = JsonUtil.objectToJavaObject(pageData.get(customLayout.getSchema()), CustomTabController.class);
            List<CustomTabControllerItem> tabItems = customTabController.getTabItems();

            // 任务
            if (type.equals(PortalConstans.PreComponentEnum.PRE_TASK.getValue())) {
                CustomTabControllerItem taskItem = tabItems.stream().filter(y -> y.getId().equals(INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId())).findFirst().orElse(null);
                if (!ObjectUtils.isEmpty(taskItem)) {
                    buildAsyncForData(taskItem, apiRequest);
                    return taskItem;
                }
            }
            // 项目追踪
            if (type.equals(PortalConstans.PreComponentEnum.PRE_PROJECT.getValue())) {
                CustomTabControllerItem projectItem = tabItems.stream().filter(y -> y.getId().equals(INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId())).findFirst().orElse(null);
                if (!ObjectUtils.isEmpty(projectItem)) {
                    buildAsyncForData(projectItem, apiRequest);
                    return projectItem;
                }
            }
            // 三方待办
            if (type.equals(PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue())) {
                CustomTabControllerItem todoItem = tabItems.stream().filter(y -> y.getId().equals(INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId())).findFirst().orElse(null);
                if (!ObjectUtils.isEmpty(todoItem)) {
                    try {
                        // 是否有三方待办权限
                        CompletableFuture<Boolean> asyncBoolean = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.queryStatus(apiRequest.getClientId(),
                                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), this.threadPoolTaskExecutor);
                        if (asyncBoolean.get()) {
                            // 查询三方待办数据
                            CompletableFuture<List<LabelSystemData>> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(),
                                    apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), this.threadPoolTaskExecutor);
                            List<LabelSystemData> tripartiteTodoList = supplyAsync.get();
                            buildTripartiteToDoData(apiRequest, tripartiteTodoList, todoItem);
                        }
                    } catch (InterruptedException | ExecutionException e) {
                        String message = e.getMessage();
                        if (null != e.getCause()) {
                            message = e.getCause().getMessage();
                        }
                        log.error("async deal tripartite todo error:{}", message, e);
                    }
                    return todoItem;
                }
            }
        }
        return new CustomTabControllerItem();
    }

    /**
     * 构建任务/项目的相关数据
     *
     * @param item
     * @param apiRequest
     */
    private void buildAsyncForData(CustomTabControllerItem item, ApiRequest apiRequest) {
        if (item.getAsyncForData()) {
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();

            // 设置当前的iamUserToken与locale
            asyncConfig.setIamUserToken(apiRequest.getIamUserToken());
            asyncConfig.setLocale(apiRequest.getLocale());
            asyncConfig.setClientId(apiRequest.getClientId());
            asyncConfig.setTenantId(apiRequest.getTenantId());

            // 设置请求地址的hostname为当前工程的外网访问地址
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + apiRequest.getClientId() + "&tenantId=" + apiRequest.getTenantId();
            asyncConfig.setRequestUrl(newUrl);
        }
        item.setName(localeService.getLanguageValue(apiRequest.getLocale(), item.getName()));
        item.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(), item.getJumpPageTitle()));
    }

    /**
     * 构建三方待办数据
     *
     * @param apiRequest          请求对象
     * @param labelSystemDataList 待办数据
     * @param item                待办组件
     */
    private void buildTripartiteToDoData(ApiRequest apiRequest, List<LabelSystemData> labelSystemDataList, CustomTabControllerItem item) {
        if (item.getAsyncForData()) {
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
            asyncConfig.setIamUserToken(apiRequest.getIamUserToken());
            asyncConfig.setLocale(apiRequest.getLocale());
            asyncConfig.setClientId(apiRequest.getClientId());
            asyncConfig.setTenantId(apiRequest.getTenantId());
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + apiRequest.getClientId() + "&tenantId=" + apiRequest.getTenantId();
            asyncConfig.setRequestUrl(newUrl);

            List<CustomTabContentContainer> content = new ArrayList<>();
            CustomTabContentContainer<Map<String, Object>> taskContent = new CustomTabContentContainer<>();
            Map<String, Object> dataMap = new HashMap<>();
            // 没有三方待办数据
            if (CollectionUtils.isEmpty(labelSystemDataList)) {
                taskContent.setContentCmptType(TripartiteTodoList.COMPONENT_TYPE);
                taskContent.setData(dataMap);
                content.add(taskContent);
                item.setContent(content);
                item.setAsyncConfig(null);
                return;
            }
            // 存在三方待办数据
            List<TripartiteTodoList> tripartiteTodoLists = new ArrayList<>();
            labelSystemDataList.forEach(labelSystemData -> {
                TripartiteTodoList<Object> tripartite = new TripartiteTodoList<>();
                tripartite.setNodeName(labelSystemData.getAppName());
                tripartite.setNodeId(String.valueOf(labelSystemData.getId()));
                tripartite.setIsExpand(true);
                tripartite.setAsyncConfig(asyncConfig);
                Map<String, Object> rowData = new HashMap<>();
                rowData.put("id", labelSystemData.getId());
                rowData.put("appCode", labelSystemData.getAppId());
                rowData.put("appName", labelSystemData.getAppName());
                rowData.put("callBackUrl", labelSystemData.getCallBackUrl());
                rowData.put("protocolType", labelSystemData.getProtocolType());
                rowData.put("isNeedSsoUrl", labelSystemData.getIsNeedSsoUrl());
                rowData.put("isFixedRefresh", labelSystemData.getIsFixedRefresh());
                tripartite.setRawData(rowData);
                tripartiteTodoLists.add(tripartite);
            });
            taskContent.setContentCmptType(TripartiteTodoList.COMPONENT_TYPE);
            dataMap.put("data", tripartiteTodoLists);
            taskContent.setData(dataMap);
            content.add(taskContent);
            item.setContent(content);
            item.setAsyncConfig(null);
        }
    }

    /**
     * 将Task/Project添加容器到Body中
     *
     * @param item
     * @param body
     */
    private void setProjectAndTask(CustomTabControllerItem item, List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        BaseMobileComponentWrapper<BaseMobileComponent> component = new BaseMobileComponentWrapper<>(item);
        component.setComponentType("DW_CUSTOM_ASYNC_LIST_VIEW");
        body.add(component);
    }

    /**
     * 构建金刚区的内容
     *
     * @param dinstrict    金刚区对象
     * @param districtInfo 查询的金刚区数据
     */
    private void buildCustomGroup(Dinstrict dinstrict, MobilePortalInfoContentResp districtInfo, PortalContentKingKongDistrict district) {
        dinstrict.setCmptVersion(2);
        dinstrict.setColumnNum(district.getColumnNum());
        dinstrict.setDisplayText(district.getIsNameShow());
        dinstrict.setLineNum(district.getLineNum());
        dinstrict.setCustomType(district.getCustomType());
        dinstrict.setInteractionType(district.getInteractionType());
        dinstrict.setTitle(districtInfo.getTitle());
        dinstrict.setIsTitleShow(districtInfo.getIsTitleShow());
        dinstrict.setColumnId(districtInfo.getColumnId());
    }

    /**
     * 生成轮播图
     *
     * @param body
     * @param districtInfo
     */
    private void setCarouselImageModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        Swiper swiper = new Swiper();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(swiper);
        componentWrapper.setComponentType("DW_" + swiper.returnComponentType());
        body.add(componentWrapper);
        buildCustomGroup(swiper, districtInfo);

        List<BaseImageContent> baseImageContentList = new ArrayList<>();
        MobileCarouselImageResp carouselImageResp = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobileCarouselImageResp.class);
        if (carouselImageResp != null) {
            swiper.setHeight(carouselImageResp.getHeight());
            swiper.setSizeMode(carouselImageResp.getHeightModel());
            swiper.setBackgroundColor(carouselImageResp.getBackgroundColor());
            swiper.setPaddingFlag(carouselImageResp.getPaddingFlag());
        }
        if (carouselImageResp != null && !CollectionUtils.isEmpty(carouselImageResp.getImageList())) {
            //组装action
            for (MobileCarouselImageInfo carouselImage : carouselImageResp.getImageList()) {
                BaseImageContent baseImageContent = new BaseImageContent();
                baseImageContent.setData(carouselImage.getContentIcon());
                baseImageContent.setDataType(2);
                //组装跳转action
                Action action = packageComponetAction(carouselImage.getJumpType(), carouselImage.getJumpTarget(), carouselImage.getCustomApplicationId(), apiRequest);
                baseImageContent.setAction(action);
                baseImageContentList.add(baseImageContent);
            }
        }
        swiper.setContent(baseImageContentList);
    }

    //封装轮播图
    private void buildCustomGroup(Swiper swiper, MobilePortalInfoContentResp districtInfo) {
        swiper.setCmptVersion(2);
        swiper.setAutoPlay(1);
        swiper.setTitle(districtInfo.getContentName());
        swiper.setTitleStyleType(3);
    }

    /**
     * 生成公告
     *
     * @param body
     * @param districtInfo
     */
    private void setNewsModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        News news = new News();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(news);
        componentWrapper.setComponentType("DW_" + news.returnComponentType());
        body.add(componentWrapper);

        news.setCmptVersion(2);
        news.setTitle(districtInfo.getContentName());

        MobileNewsResp mobileNewsResp = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobileNewsResp.class);
        if (mobileNewsResp != null) {
            news.setShowPublishTime(mobileNewsResp.getPublishTimeFlag());
            news.setShowReadCount(mobileNewsResp.getReadNumFlag());
            news.setStyle(mobileNewsResp.getNewsModel());
            //-1 表示查询的公告类型不存在
            news.setNewsTypeId(!ObjectUtils.isEmpty(mobileNewsResp.getNewsTypeId()) ? mobileNewsResp.getNewsTypeId() : -1);
            news.setChildrenNewsTypeId(mobileNewsResp.getChildrenNewsTypeId());
            news.setNewsCount(mobileNewsResp.getNewsCount());
            news.setNewsLikeCountFlag(mobileNewsResp.getNewsLikeCountFlag());
        }
    }

    /**
     * 构建分割线信息
     *
     * @param body         返回提
     * @param districtInfo 分割线内容
     */
    private void setDividerInfo(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo) {
        AuxiliaryLine auxiliaryLine = new AuxiliaryLine();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(auxiliaryLine);
        componentWrapper.setComponentType("DW_" + auxiliaryLine.returnComponentType());
        body.add(componentWrapper);

        auxiliaryLine.setCmptVersion(2);
        MobileDividerResp dividerInfo = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobileDividerResp.class);
        if (!ObjectUtils.isEmpty(dividerInfo)) {
            auxiliaryLine.setHeight(dividerInfo.getHeight());
            auxiliaryLine.setBackgroundColor(dividerInfo.getBackgroundColor());
            auxiliaryLine.setLineStyleFlag(dividerInfo.getLineStyleFlag());
            auxiliaryLine.setLineColor(dividerInfo.getLineColor());
        }
    }

    /**
     * 生成标题组件信息
     * @param body
     * @param districtInfo
     */
    private void setTitleInfoModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body,
                                    MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        PortalTitle title = new PortalTitle();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(title);
        componentWrapper.setComponentType("DW_" + title.returnComponentType());
        body.add(componentWrapper);

        MobilePortalTitleInfoRespVO titleInfo = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobilePortalTitleInfoRespVO.class);
        if (null == titleInfo) {
            return;
        }
        title.setBackgroundColor(titleInfo.getBackgroundColor());
        title.setTitle(titleInfo.getMainTitleName());
        title.setSubTitle(titleInfo.getSubTitleName());
        TitleColor titleTextStyle = new TitleColor();
        titleTextStyle.setColor(titleInfo.getMainTitleColor());
        title.setTitleTextStyle(titleTextStyle);
        TitleColor subTitleTextStyle = new TitleColor();
        subTitleTextStyle.setColor(titleInfo.getSubTitleColor());
        title.setSubTitleTextStyle(subTitleTextStyle);
        title.setLinkFlag(titleInfo.getLinkFlag());
        //显示链接（0：不展示；1：展示）
        if (null != titleInfo.getLinkFlag() &&
                titleInfo.getLinkFlag().equals(PortalConstans.IconFlagEnum.IS_SHOW.getFlag())) {
            TitleColor rightTitleTextStyle = new TitleColor();
            rightTitleTextStyle.setColor(titleInfo.getLinkColor());
            title.setRightTitle(titleInfo.getLinkName());
            title.setRightTitleTextStyle(rightTitleTextStyle);
            //组装跳转action
            Action action = packageComponetAction(titleInfo.getJumpType(), titleInfo.getJumpTarget(), titleInfo.getCustomApplicationId(), apiRequest);
            title.setAction(action);
        }
        TitleStyle leaderStyle = new TitleStyle();
        leaderStyle.setIcon(titleInfo.getIconUrl());
        //设置头部风格，头部风格 0无 1色块 2图标
        // 不展示色块或者图标
        if (titleInfo.getIconFlag().equals(PortalConstans.IconFlagEnum.NO_SHOW.getFlag())) {
            leaderStyle.setStyle(PortalConstans.LeaderStyleEnum.EMPTY.getVal());
        }
        //当展示图标，色块或者图标
        if (titleInfo.getIconFlag().equals(PortalConstans.IconFlagEnum.IS_SHOW.getFlag())) {
            //如果图标样式为色块，那么头部风格为1色块，否则头部风格为2图标
            Integer style = titleInfo.getIconStyle().equals(PortalConstans.IconStyleEnum.COLOR.getVal()) ? PortalConstans.LeaderStyleEnum.COLOR.getVal() : PortalConstans.LeaderStyleEnum.ICON.getVal();
            leaderStyle.setStyle(style);
        }
        leaderStyle.setColor(titleInfo.getIconColor());
        //图标资源类型, 0-APP内部资源 1-IconFont 2-网络资源
        leaderStyle.setIconType(PortalConstans.IconTypeEnum.NET_WORK.getVal());
        title.setLeaderStyle(leaderStyle);
    }


    /**
     * 生成图片组件信息
     * @param body
     * @param districtInfo
     */
    private void setPictureModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body,
                                  MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        PictureComponent picture = new PictureComponent();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(picture);
        componentWrapper.setComponentType("DW_" + picture.returnComponentType());
        body.add(componentWrapper);
        MobilePortalImageInfoRespVO imageCompInfo = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobilePortalImageInfoRespVO.class);
        if (null == imageCompInfo) {
            return;
        }
        picture.setPicUrl(imageCompInfo.getImageUrl());
        List<PictureHotZone> areaList = new ArrayList<>();
        //组装热区
        for (MobilePortalHotZoneRespVO hotZone : imageCompInfo.getHotZoneList()) {
            PictureHotZone area = new PictureHotZone();
            //组装跳转action
            Action action = packageComponetAction(hotZone.getJumpType(), hotZone.getJumpTarget(), hotZone.getCustomApplicationId(), apiRequest);
            area.setAction(action);
            area.setPosition(hotZone.getCoordinate());
            areaList.add(area);
        }
        picture.setArea(areaList);
    }

    /**
     * 生成业务入口组件信息
     * @param body
     * @param districtInfo
     */
    private void setBusinessModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body,
                                   MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        BusinessComponent business = new BusinessComponent();
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(business);
        componentWrapper.setComponentType("DW_" + business.returnComponentType());
        body.add(componentWrapper);
        MobilePortalBusinessInfoRespVO businessCompInfo = JsonUtil.jsonStringToObject(districtInfo.getContentAttr(), MobilePortalBusinessInfoRespVO.class);
        if (null == businessCompInfo) {
            return;
        }
        business.setStyle(businessCompInfo.getBusStyle());
        business.setBackgroundColor(businessCompInfo.getBusBgColor());
        List<BusinessImage> imageList = new ArrayList<>();
        //组装图片入口
        for (MobilePortalBusImageRespVO imageRespVO : businessCompInfo.getImageList()) {
            BusinessImage iamge = new BusinessImage();
            //组装跳转action
            Action action = packageComponetAction(imageRespVO.getJumpType(), imageRespVO.getJumpTarget(), imageRespVO.getCustomApplicationId(), apiRequest);
            iamge.setAction(action);
            iamge.setPicUrl(imageRespVO.getImageUrl());
            imageList.add(iamge);
        }
        business.setData(imageList);
    }

    /**
     *组装跳转action
     * @param jumpType 跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告）
     * @param jumpTarget 跳转目标（pageID的值 或者 链接地址）
     * @param customApplicationId 应用/作业Id
     * @param apiRequest
     * @return
     */
    public Action packageComponetAction(Integer jumpType, String jumpTarget, Long customApplicationId, ApiRequest apiRequest) {
        Action action = null;
        //Action--自定义url
        if (PortalConstans.JumpTypeEnum.CUSTOMIZE_URL.getValue().equals(jumpType)) {
            MobileBallResp mobileBallResp = new MobileBallResp();
            mobileBallResp.setBallName("");
            mobileBallResp.setJumpTarget(jumpTarget);
            action = ballRouter.getCompoentAction(PortalConstans.CUSTOM, apiRequest, mobileBallResp);
        }
        //Action--应用作业
        if (PortalConstans.JumpTypeEnum.SSO_CONFIGURATION.getValue().equals(jumpType)) {
            MobileBallResp mobileBallResp = new MobileBallResp();
            mobileBallResp.setCustomApplicationId(customApplicationId);
            mobileBallResp.setCallBackUrl("");
            mobileBallResp.setBallName("");
            action = ballRouter.getCompoentAction(PortalConstans.CUSTOM_APPLICATION, apiRequest, mobileBallResp);
        }
        //Action--常用功能
        if (PortalConstans.JumpTypeEnum.COMMONLY_USERD_FUNCTIONS.getValue().equals(jumpType) && StringUtil.isNotEmpty(jumpTarget)) {
            action = ballRouter.getCompoentAction(PortalConstans.ActionEnum.getNameByValue(Integer.valueOf(jumpTarget)), apiRequest, new MobileBallResp());
        }
        //Action--自定义页面
        if (PortalConstans.JumpTypeEnum.CUSTOM_PAGE.getValue().equals(jumpType)) {
            MobileBallResp mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = ballRouter.getCompoentAction(PortalConstans.CUSTOM_PAGE, apiRequest, mobileBallResp);
        }
        //Action--公告
        if (PortalConstans.JumpTypeEnum.MOBILE_NEWS.getValue().equals(jumpType)) {
            MobileBallResp mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = ballRouter.getCompoentAction(PortalConstans.MOBILE_NEWS, apiRequest, mobileBallResp);
        }
        //Action--公告类型
        if (PortalConstans.JumpTypeEnum.MOBILE_NEWS_TYPE.getValue().equals(jumpType)) {
            MobileBallResp mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = ballRouter.getCompoentAction(PortalConstans.MOBILE_NEWS_TYPE, apiRequest, mobileBallResp);
        }
        return action;
    }

    /**
     * 判断作业id是否匹配
     *
     * @param userId
     * @param pgrrGoodsCode
     * @param iamUserToken
     * @param module
     * @return
     */
    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;

        Optional optional = Optional.ofNullable(userPermission)
                .map(DigiwinIamUserAuthInfo::getResult)
                .map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent()) {
            if (userPermission != null && userPermission.getResult() != null) {
                isMatchWorkId = userPermission.getResult().getPermissions().
                        stream().anyMatch(e -> e.getId().equals(module.getWorkId())
                        && "allow".equalsIgnoreCase(e.getEffect()));
            }

        }
        return isMatchWorkId;
    }
}
