package com.digiwin.mobile.mobileuibot.index;


import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;

@Slf4j
@Component("uiBotModelBuildIndexPortalStrategy")
public class UiBotModelBuildIndexPortalStrategy implements UiBotModelBuildStrategy {
    @Autowired
    private TaskService taskService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private IndexBuildStrategyFactory indexBuildStrategyFactory;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexPortal");
        stopWatch.start();
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
//            uiBotModel = this.doMockData(pageSetting, apiRequest);
            uiBotModel = UiBotModel.emptyUiBotModel();
        }
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel;
        PageSetting indexHasDataPageSetting = this.pageSettingService
                .findById(PageSettingIdPresetEnum.INDEX_HAS_WORK.toString());
        uiBotModel = this.indexBuildStrategyFactory
                .get(PageSettingIdPresetEnum.INDEX_PORTAL.toString()).build(apiRequest, indexHasDataPageSetting, true);
        return uiBotModel;
    }
}
