package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.search.Search;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.List;

/**
 * <p>功能描述：首页界面生成策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildIndexStrategy
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:05
 */
@Slf4j
@Component("uiBotModelBuildIndexStrategy")
public class UiBotModelBuildIndexStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private TaskService taskService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private IndexBuildStrategyFactory indexBuildStrategyFactory;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndex");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        log.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        // TODO 创建首页的逻辑
        /**
         * 创建逻辑如下：
         * 1. 调用ATMC查询任务列表，判断是否有任务。若有任务，则跳到第3步；若没有任务，则跳到第2步
         * 2. 调用ATMC查询项目列表，判断是否有项目。若有项目，则跳到第3步；若没有项目，则跳到第4步
         * 3. 通过IndexBuildStrategyFactory首页构造策略工厂类找到“什么都有的首页”的构造策略类，创建首页的UiBotModel数据
         * 4. 通过IndexBuildStrategyFactory首页构造策略工厂类找到“什么都没有首页”的构造策略类，创建首页的UiBotModel数据
         * 5. 返回UiBotModel数据
         */
        stopWatch.start("Build Index Page Model");
        UiBotModel uiBotModel;
        Boolean hasProjectData = this.hasProjectData(apiRequest);
        PageSetting indexHasDataPageSetting = this.pageSettingService
                .findById(PageSettingIdPresetEnum.INDEX_HAS_WORK.toString());
        uiBotModel = this.indexBuildStrategyFactory
                .get(PageSettingIdPresetEnum.INDEX_HAS_WORK.toString()).build(apiRequest, indexHasDataPageSetting, hasProjectData);
        stopWatch.stop();
        return uiBotModel;
    }

    private boolean hasTaskData(ApiRequest apiRequest) {
        boolean hasTaskData = false;
        try {
            hasTaskData = !this.taskService.getDigiwinAtmcBacklogList(apiRequest).isEmpty();
            return hasTaskData;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean hasProjectData(ApiRequest apiRequest) {
        boolean hasProjectData = false;
        try {
            List<CardCategory> cardCategoryList = this.projectService.getProjectList(apiRequest);
            int actualProjectCount =
                    cardCategoryList.stream().mapToInt(cardCategory -> cardCategory.getCardList().size()).sum();
            hasProjectData = actualProjectCount > 0;
            return hasProjectData;
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
        return false;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        data = FileUtil.readText("static/appstore-use/index.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        //设置全局搜索组件按钮多语言
        for (UiBotLayout layout : layoutList) {
            if (layout.getType().equals(Search.COMPONENT_TYPE)
                    && pageData.get(layout.getSchema()) != null) {
                Search search =
                        JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Search.class);
                search.initSetting(apiRequest.getLocale());
                pageData.put(layout.getSchema(), search);
            }
        }

        return uiBotModel;
    }
}
