package com.digiwin.mobile.mobileuibot.information;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.information.request.InformationBoardVO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.InformationBoard;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述： 全局资讯控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InformationController.java
 * @Author: wangjwc
 * @Date: created at 2024/11/11 18:24
 */
@RestController
@RequestMapping("/mobile/v1/information")
public class InformationController {

    @Autowired
    private InformationService informationService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value = "/board/add")
    public ApiResponse<InformationBoardVO> boardAdd(@RequestBody InformationBoardVO vo) {
        return ApiResponse.buildOK().setData(InformationBoardVO.convert(informationService.boardAdd(vo)));
    }

    @PostMapping(value = "/board/update")
    public ApiResponse<InformationBoardVO> boardUpdate(@RequestBody InformationBoardVO vo) {
        InformationBoard board = informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError(localeService.getLanguageValue(vo.getLocale(), "看板记录不存在"));
        }
        return ApiResponse.buildOK().setData(InformationBoardVO.convert(informationService.boardUpdate(vo)));
    }

    @PostMapping(value = "/board/delete")
    public ApiResponse<InformationBoardVO> boardDelete(@RequestBody InformationBoardVO vo) {
        InformationBoard board = informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError(localeService.getLanguageValue(vo.getLocale(), "看板记录不存在"));
        }
        informationService.boardDelete(vo.getBoardId());
        return ApiResponse.buildOK().setData(InformationBoardVO.convert(board));
    }

    @PostMapping(value = "/board/select")
    public ApiResponse<InformationBoardVO> boardSelect(@RequestBody InformationBoardVO vo) {
        InformationBoard board = informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError(localeService.getLanguageValue(vo.getLocale(), "看板记录不存在"));
        }
        return ApiResponse.buildOK().setData(InformationBoardVO.convert(board));
    }

    @PostMapping(value = "/board/list")
    public ApiResponse<List<InformationBoardVO>> boardList(@RequestBody InformationBoardVO vo) {
        List<InformationBoard> boardList = informationService.boardList(vo.getTenantId(), vo.getUserId());
        List<InformationBoardVO> boardVOList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(boardList)) {
            boardList.forEach(board -> boardVOList.add(InformationBoardVO.convert(board)));
        }
        return ApiResponse.buildOK().setData(boardVOList);
    }

    /**
     * 获取Tbb报表列表
     */
    @PostMapping(value = "/report/list")
    public ApiResponse<List<DigiwinAtmcTmDataReport>> reportList(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(informationService.reportList(apiRequest));
    }
}
