package com.digiwin.mobile.mobileuibot.information;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.information.request.InformationBoardVO;
import com.digiwin.mobile.mobileuibot.model.db1.InformationBoard;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;

import java.util.List;

/**
 * <p>功能描述: 全局资讯服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InformationService.java
 * @Author: wangjwc
 * @Date: created at 2024/11/11 18:26
 */
public interface InformationService {
    /**
     * 根据boardId查询资讯板块信息
     * @param boardId 看板ID
     * @return
     */
    InformationBoard selectByBoardId(String boardId);

    /**
     *  新增资讯板块信息
     * @param vo 请求参数
     * @return
     */
    InformationBoard boardAdd(InformationBoardVO vo);

    /**
     * 更新资讯板块信息
     * @param vo 请求参数
     * @return
     */
    InformationBoard boardUpdate(InformationBoardVO vo);

    /**
     * 删除资讯板块信息
     * @param boardId 看板ID
     * @return
     */
    int boardDelete(String boardId);

    /**
     * 查询资讯板块列表
     * @param tenantId 租户ID
     * @param userId    用户ID
     * @return
     */
    List<InformationBoard> boardList(String tenantId, String userId);

    /**
     *  查询报表列表
     * @param apiRequest 请求参数
     * @return
     */
    List<DigiwinAtmcTmDataReport> reportList(ApiRequest apiRequest);
}
