package com.digiwin.mobile.mobileuibot.information;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.information.request.InformationBoardVO;
import com.digiwin.mobile.mobileuibot.mapper.db1.InformationBoardMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db1.InformationBoard;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：全局资讯服务接口实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InformationServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/11/11 18:27
 */
@Service
public class InformationServiceImpl implements InformationService {

    @Autowired
    private InformationBoardMapper boardMapper;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Override
    public InformationBoard selectByBoardId(String boardId) {
        LambdaQueryWrapper<InformationBoard> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(InformationBoard::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(InformationBoard::getBoardId, boardId);
        return boardMapper.selectOne(wrapper, false);
    }

    @Override
    public InformationBoard boardAdd(InformationBoardVO vo) {
        InformationBoard board = new InformationBoard().setBoardId(UUIDUtil.getUuid())
                .setTenantId(vo.getTenantId()).setUserId(vo.getUserId())
                .setBoardName(vo.getBoardName()).setBoardContent(JsonUtil.javaObjectToJsonString(vo.getBoardContent()))
                .setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date());
        boardMapper.insert(board);
        return this.selectByBoardId(board.getBoardId());
    }

    @Override
    public InformationBoard boardUpdate(InformationBoardVO vo) {
        InformationBoard board = new InformationBoard().setBoardId(vo.getBoardId())
                .setBoardName(vo.getBoardName()).setBoardContent(JsonUtil.javaObjectToJsonString(vo.getBoardContent()));
        boardMapper.updateById(board);
        return this.selectByBoardId(board.getBoardId());
    }

    @Override
    public int boardDelete(String boardId) {
        LambdaUpdateWrapper<InformationBoard> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(InformationBoard::getBoardId, boardId);
        updateWrapper.eq(InformationBoard::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        updateWrapper.set(InformationBoard::getDelFlag, DelFlagEnum.DELETE.getValue());
        return boardMapper.update(null, updateWrapper);
    }

    @Override
    public List<InformationBoard> boardList(String tenantId, String userId) {
        LambdaQueryWrapper<InformationBoard> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(InformationBoard::getTenantId, tenantId);
        wrapper.eq(InformationBoard::getUserId, userId);
        wrapper.eq(InformationBoard::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByDesc(InformationBoard::getUpdateTime);
        List<InformationBoard> boardList = boardMapper.selectList(wrapper);
        return CollectionUtils.isEmpty(boardList) ? Collections.emptyList() : boardList;
    }

    @Override
    public List<DigiwinAtmcTmDataReport> reportList(ApiRequest apiRequest) {
        List<DigiwinAtmcTmData> tmDataList = digiwinAudcProxyService.getTmDataList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty(tmDataList)) {
            return Collections.emptyList();
        }
        return tmDataList.stream()
                .map(DigiwinAtmcTmData::getBaseItemDtoList)
                .flatMap(Collection::stream)
                // 过滤TBB报表
                .filter(item -> ReportCategoryEnum.STATEMENT.getValue().equals(item.getCategory()))
                .collect(Collectors.toList());
    }
}
