package com.digiwin.mobile.mobileuibot.information.request;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.model.db1.InformationBoard;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：资讯看板VO对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InformationBoardVO.java
 * @Author: wangjwc
 * @Date: created at 2024/11/11 18:42
 */
@Data
@Accessors(chain = true)
public class InformationBoardVO implements Serializable {
    private static final long serialVersionUID = -7115048063382243563L;
    /**
     * 看板ID
     */
    private String boardId;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 看板名称
     */
    private String boardName;
    /**
     * 看板内容-数组
     */
    private List<InformationBoardReportVO> boardContent;

    private String locale;
    private String iamUserToken;

    public static InformationBoardVO convert(InformationBoard board) {
        if (board == null) {
            return null;
        }
        return new InformationBoardVO()
                .setBoardId(board.getBoardId())
                .setTenantId(board.getTenantId())
                .setUserId(board.getUserId())
                .setBoardName(board.getBoardName())
                .setBoardContent(buildBoardContent(board.getBoardContent()));
    }

    private static List<InformationBoardReportVO> buildBoardContent(String boardContent) {
        if (!StringUtils.hasLength(boardContent)) {
            return new ArrayList<>();
        }
        List<InformationBoardReportVO> boardContentVO = JsonUtil.jsonStringToObject(boardContent, new TypeReference<List<InformationBoardReportVO>>() {
        });
        if (CollectionUtils.isEmpty(boardContentVO)) {
            return boardContentVO;
        }
        boardContentVO.forEach(item ->
                item.setH5Url(BottomButtonDigiwinAthena.buildTbbH5Url(
                        AppRequestContext.getContextEntity().getLocale(),
                        AppRequestContext.getContextEntity().getIamUserToken(),
                        AppRequestContext.getContextEntity().getTenantId(),
                        Optional.ofNullable(item.getResCode()).filter(StrUtil::isNotEmpty).orElse(item.getCode()),
                        item.getName())));
        return boardContentVO;
    }
}