package com.digiwin.mobile.mobileuibot.locale;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.locale.model.TranslateRequest;
import com.digiwin.mobile.mobileuibot.locale.model.TranslateResponse;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.TranslateService;
import com.digiwin.mobile.mobileuibot.model.db1.LanguageSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 多语言接口
 *
 * @author zhangjj
 * @date 2022/11/3 16:55
 */
@RestController
@RequestMapping(value = "/mobile/v1/locale")
public class LocaleController {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private TranslateService translateService;

    /**
     * 重新加载所有缓存
     *
     * @return
     */
    @GetMapping(value = "/cache/all")
    public Boolean cacheAllLanguageSourceList() {
        localeService.cacheAllLanguageSourceList();
        return true;
    }

    /**
     * 新增/更新单笔多语言信息（按简体中文更新）
     *
     * @param languageSource
     */
    @PostMapping(value = "/languageSource/add")
    public Boolean addOrUpdateLanguageSource(@RequestBody LanguageSource languageSource) {
        if (!StringUtils.hasLength(languageSource.getPhrase())) {
            return false;
        }
        if (!StringUtils.hasLength(languageSource.getLocale())) {
            return false;
        }
        if (!StringUtils.hasLength(languageSource.getSourceValue())) {
            return false;
        }
        return localeService.addOrUpdateLanguageSource(languageSource);
    }

    /**
     * 简转繁
     *
     * @param value
     * @return
     */
    @CrossOrigin
    @GetMapping("/translate/zh2Hant/{value}")
    public String zh2HantForFront(@PathVariable(value = "value") String value) {
        return translateService.zh2Hant(value);
    }

    /**
     * 简转英
     *
     * @param value
     * @return
     */
    @CrossOrigin
    @GetMapping("/translate/zh2En/{value}")
    public String zh2EnForFront(@PathVariable(value = "value") String value) {
        return translateService.zh2EN(value);
    }

    /**
     * 简转繁（后端使用）
     *
     * @param value
     * @return
     */
    @Deprecated
    @CrossOrigin
    @GetMapping("/back/zh2Hant/{value}")
    public String zh2HantForBack(@PathVariable(value = "value") String value) {
        return "result.put(\"dj-mobile-" + value + "\", \"" + translateService.zh2Hant(value) + "\");";
    }

    /**
     * 翻译
     *
     * @param translateRequest 翻译请求参数
     * @return ApiResponse<TranslateResponse>
     */
    @CrossOrigin
    @PostMapping("/translate")
    public ApiResponse<TranslateResponse> translate(@Valid @RequestBody TranslateRequest translateRequest) {
        return ApiResponse.buildOK(translateService.translate(translateRequest));
    }
}
