package com.digiwin.mobile.mobileuibot.locale.cache;

import com.digiwin.mobile.mobileuibot.config.CacheConfig;
import com.digiwin.mobile.mobileuibot.model.db1.LanguageSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 多语言数据缓存
 *
 * @author zhangjj
 * @date 2022/11/9 10:43
 */
@Component
public class LocaleCache {

    public static final String LANGUAGE_CACHE_NAME = "languageSourceList";

    @Autowired
    private CacheConfig cacheConfig;

    /**
     * 将多语言数据批量存入缓存
     *
     * @param languageSourceList
     */
    public void putLanguageSourceList(List<LanguageSource> languageSourceList) {
        if (CollectionUtils.isEmpty(languageSourceList)) {
            return;
        }
        CaffeineCacheManager cacheManager = cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        languageSourceList.forEach(languageSource ->
                cache.put(languageSource.getPhrase() + "-" + languageSource.getLocale(), languageSource.getSourceValue())
        );
    }

    /**
     * 将多语言数据存入缓存
     *
     * @param languageSource
     */
    public void putLanguageSource(LanguageSource languageSource) {
        if (languageSource == null) {
            return;
        }
        CaffeineCacheManager cacheManager = cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        cache.put(languageSource.getPhrase() + "-" + languageSource.getLocale(), languageSource.getSourceValue());
    }

    /**
     * 从缓存获取多语言信息
     *
     * @param locale
     * @param phrase
     * @return
     */
    public String getLanguageCache(String locale, String phrase) {
        if (!StringUtils.hasLength(phrase)) {
            return "";
        }
        CaffeineCacheManager cacheManager = cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        return cache.get(phrase + "-" + locale, String::new);
    }

}
