package com.digiwin.mobile.mobileuibot.locale.model;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：翻译请求对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TranslateRequest.java
 * @Author: wangjwc
 * @Date: created at 2025/9/2 11:40
 */
@Data
public class TranslateRequest implements Serializable {
    private static final long serialVersionUID = -1312110190191056172L;

    /**
     * 内容
     */
    @NotBlank(message = "翻译内容不能为空")
    private String content;

    /**
     * convertTypes["zh2Hant","zh2Hans","zh2En"]
     * zh2Hant:中文转繁体
     * zh2Hans:中文转简体
     * zh2En:中文转英文
     */
    @NotEmpty(message = "转换类型不能为空")
    private List<String> convertTypes;
}
