package com.digiwin.mobile.mobileuibot.locale.service;

import com.digiwin.mobile.mobileuibot.model.db1.LanguageSource;

/**
 * 多语言service
 *
 * @author zhangjj
 * @date 2022/11/9 10:11
 */
public interface LocaleService {

    /**
     * 缓存所有多语言数据
     */
    void cacheAllLanguageSourceList();

    /**
     * 获取对应语言别的字符串
     *
     * @param phrase 字符串
     * @return 对应语言别的字符串
     */
    String getLanguageValue(String phrase);

    /**
     * 获取对应语言别的字符串
     *
     * @param locale
     * @param phrase
     * @return
     */
    String getLanguageValue(String locale, String phrase);

    /**
     * 新增/更新多语言信息
     *
     * @param languageSource
     * @return
     */
    Boolean addOrUpdateLanguageSource(LanguageSource languageSource);

}
