package com.digiwin.mobile.mobileuibot.locale.service;

import com.digiwin.mobile.mobileuibot.locale.model.TranslateRequest;
import com.digiwin.mobile.mobileuibot.locale.model.TranslateResponse;

/**
 * 翻译Service
 *
 * @author zhangjj
 * @date 2022/11/3 16:46
 */
public interface TranslateService {

    /**
     * 简体转繁体
     *
     * @param value
     * @return
     */
    String zh2Hant(String value);


    /**
     * 简体转英文
     *
     * @param value
     * @return
     */
    String zh2EN(String value);

    /**
     * 获取luckycola的ColaKey
     *
     * @return
     */
    String getColaKey();

    /**
     * 翻译
     *
     * @param translateRequest 翻译请求
     * @return 翻译结果
     */
    TranslateResponse translate(TranslateRequest translateRequest);
}
