package com.digiwin.mobile.mobileuibot.login;

import java.util.Objects;

/**
 * <p>功能描述：登录来源功能（或界面）枚举</p>
 *
 * @FileName: LoginFromEnum
 * @Author: zaregoto
 * @Date: 2024/4/9 17:26
 */
public enum LoginFromEnum {
    // 功能：『我要体验』
    EXPERIENCE("experience"),

    ;

    private final String value;

    LoginFromEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static LoginFromEnum getEnumByValue(String value) {
        for (LoginFromEnum testedEnum : LoginFromEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
