package com.digiwin.mobile.mobileuibot.login;

import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;

/**
 * <p>功能描述：APP端登录服务</p>
 * TODO 未来需随着ProxyController中的登录接口挪到LoginController后，逻辑代码也挪到这里面
 *
 * @FileName: LoginService
 * @Author: zaregoto
 * @Date: 2024/4/9 16:45
 */
public interface LoginService {

    /**
     * 在体验模式中使用短信验证码登录的后续处理
     *
     * @param mobilePhone      用户手机号
     * @param verificationCode 手机收到的验证码
     * @param locale           用户语言别
     * @param clientAgent      客户id
     * @param expRoleId        体验角色ID
     * @param loginResponse   登录后的响应实体类
     * @param mock             mock体验下配置
     * @return
     */
    void handleUserByVerificationCodeInExperience(String mobilePhone,
                                                                                    String verificationCode,
                                                                                    String locale,
                                                                                    String clientAgent,
                                                                                    String expRoleId,
                                                                                    DigiwhaleLoginResponse loginResponse,
                                                                                    Mock mock,
                                                                                    String iamDeviceId) throws Exception;
}
