package com.digiwin.mobile.mobileuibot.machinePreset.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.machinePreset.model.ApiRequestCompanyFactory;
import com.digiwin.mobile.mobileuibot.machinePreset.service.MachinePresetService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.CompanyFactoryResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetJobResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.*;

/***
 * 绿色智机
 */
@RestController
@RequestMapping("/machine/preset/")
@Slf4j
public class MachinePresetController {

    @Autowired
    MachinePresetService machinePresetService;

    @Autowired
    DigiwinSemcProxyService semcProxyService;

    @Autowired
    private AppEntranceRecordService appEntranceRecordService;

    @Autowired
    private LocaleService localeService;

    /***
     * 获取公司别厂别
     * @param apiRequest
     * @return
     */
    @PostMapping("/getCompanyFactoryList")
    public ApiResponse getCompanyFactoryList(@RequestBody ApiRequest apiRequest) {
        List<CompanyFactoryResp> list = machinePresetService.getCompanyFactoryList(apiRequest);
        return ApiResponse.buildOK().setData(list);
    }

    /***
     * 保存公司别厂别
     *
     * @param apiRequestCompanyFactory@return
     */
    @PostMapping("/saveCompanyFactory")
    public ApiResponse saveCompanyFactory(@RequestBody @Valid ApiRequestCompanyFactory apiRequestCompanyFactory) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setTenantId(apiRequestCompanyFactory.getTenantId());
        apiRequest.setIamUserToken(apiRequestCompanyFactory.getIamUserToken());
        machinePresetService.saveCompanyFactory(apiRequest, apiRequestCompanyFactory.getCompany(), apiRequestCompanyFactory.getFactory());
        return ApiResponse.buildOK();
    }


    /***
     * 查询绿色智机项目权限接口
     * @return
     */
    @PostMapping("/queryUserAuth")
    public ApiResponse queryUserAuth(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(machinePresetService.queryUserAuth(apiRequest));
    }


    /***
     * 查询工作台模组作业接口
     * @return
     */
    @PostMapping("/workBench/queryAppJob")
    public ApiResponse<UiBotModel> queryAppJob(@RequestBody CustomContentRequest customContentRequest) {
        Map<String, Object> sysParam = customContentRequest.getSysParam();
        String locale = (String) sysParam.get("locale");
        String iamUserToken = (String) sysParam.get("iamUserToken");
        log.debug("workBench/queryAppJob req{}", JSONObject.toJSONString(sysParam));
        //查询用户模组作业
        List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(new ArrayList<String>(), locale, iamUserToken);
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        //没有模组作业
        if (CollUtil.isEmpty(topicPresetRespList)) {
            return ApiResponse.buildOK().setData(uiBotModel);
        }
        List<UiBotLayout> layoutList = new ArrayList<>();
        try {
            Map<String, TopicPresetResp> topicPresetRespMap = addAppUiBot(topicPresetRespList, layoutList);
            //组装模组和作业
            UiBotPageData pageData = new UiBotPageData();
            packagePageData(pageData, topicPresetRespMap,locale);
            uiBotModel.setLayout(layoutList);
            uiBotModel.setPageData(pageData);
        } catch (Exception e) {
            log.error("workBench/queryAppJob req{},error:{}", JSONObject.toJSONString(sysParam), e.getMessage());
            return ApiResponse.buildOK().setData(uiBotModel);
        }
        return ApiResponse.buildOK().setData(uiBotModel);
    }


    /**
     * 组装模组和作业
     *
     * @param pageData
     * @param topicPresetRespMap
     */
    public void packagePageData(UiBotPageData pageData, Map<String, TopicPresetResp> topicPresetRespMap,String locale) {
        //遍历组装返回数据
        Set<Map.Entry<String, TopicPresetResp>> entries = topicPresetRespMap.entrySet();
        for (Map.Entry<String, TopicPresetResp> entry : entries) {
            String uuid = entry.getKey();
            TopicPresetResp topicPreset = entry.getValue();
            CustomGroup customGroup = new CustomGroup();
            customGroup.setName(topicPreset.getModuleName());
            CustomGroupContent content = packageJob(topicPreset, uuid,locale);
            customGroup.setContent(content);
            pageData.put(uuid, customGroup);
        }
    }

    /**
     * 组装模组下作业
     *
     * @param topicPreset
     * @param uuid
     */
    public CustomGroupContent packageJob(TopicPresetResp topicPreset, String uuid,String locale) {
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> layoutList = new ArrayList<>();
        UiBotLayout layout = new UiBotLayout();
        layout.setSchema(uuid);
        layout.setType(AppEntrance.COMPONENT_TYPE);
        layoutList.add(layout);
        content.setLayout(layoutList);
        UiBotPageData pageData = new UiBotPageData();
        AppEntrance appEntrance = new AppEntrance();
        //组装作业信息
        List<AppFunctionTouchable> appList = addJobTouchable(topicPreset.getTopicpList(),locale);
        appEntrance.setAppList(appList);
        pageData.put(uuid, appEntrance);
        content.setPageData(pageData);
        return content;
    }


    /**
     * 组装作业appList
     *
     * @param topicpList 返回的权限内作业信息
     * @return
     */
    public List<AppFunctionTouchable> addJobTouchable(List<TopicPresetJobResp> topicpList,String locale) {
        List<AppFunctionTouchable> appList = new ArrayList<>();
        //组装作业信息
        for (TopicPresetJobResp topicp : topicpList) {
            AppFunctionTouchable touchable = new AppFunctionTouchable();
            //作业图片地址
            touchable.setIconUrl(topicp.getTopicPresetIcon());
            //作业名称
            touchable.setName(topicp.getTopicPresetName());
            //作业caseId，用于金刚区记录
            touchable.setId(topicp.getCaseId());
            Action action = new Action();
            action.setOpenWebPageTitle(topicp.getTopicPresetName());
            //跳转url
            action.setRequestUrl(topicp.getTopicPresetUrl());
            //跳转类型-webview
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            //如果没有设置公司别和厂别，给出提示
            if(!topicp.getIsSetCompany()){
                action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                action.setToastMsg(localeService.getLanguageValue(locale, "请先设置公司别和厂别"));
            }
            touchable.setAction(action);
            appList.add(touchable);
        }
        return appList;
    }

    /**
     * 生成模组的Layout
     *
     * @param topicPresetRespList
     * @return
     */
    public Map<String, TopicPresetResp> addAppUiBot(List<TopicPresetResp> topicPresetRespList, List<UiBotLayout> layoutList) {
        Map<String, TopicPresetResp> topicPresetRespMap = new HashMap<>();
        for (TopicPresetResp topicPreset : topicPresetRespList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType(CustomGroup.COMPONENT_TYPE);
            layoutList.add(layout);
            topicPresetRespMap.put(schema, topicPreset);
        }
        return topicPresetRespMap;
    }


    /***
     * 查询金刚区作业接口
     * @return
     */
    @PostMapping("/myBench/queryClickAppJob")
    public ApiResponse<UiBotModel> queryClickAppJob(@RequestBody CustomContentRequest customContentRequest) {
        Map<String, Object> sysParam = customContentRequest.getSysParam();
        String locale = (String) sysParam.get("locale");
        String iamUserToken = (String) sysParam.get("iamUserToken");
        String tenantId = (String) sysParam.get("tenantId");
        String userId = (String) sysParam.get("userId");
        log.debug("myBench/queryClickAppJob req{}", JSONObject.toJSONString(sysParam));
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        try {
            List<String> commonAppIdList = appEntranceRecordService.getAppIdListByUserId(userId, tenantId);
            if (CollectionUtils.isEmpty(commonAppIdList)) {
                return ApiResponse.buildOK().setData(uiBotModel);
            }
            //查询用户模组作业
            List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(commonAppIdList, locale, iamUserToken);
            //没有模组作业
            if (CollUtil.isEmpty(topicPresetRespList)) {
                return ApiResponse.buildOK().setData(uiBotModel);
            }
            //组装作业
            UiBotPageData pageData = new UiBotPageData();
            List<UiBotLayout> layoutList = new ArrayList<>();
            UiBotLayout layout = new UiBotLayout();
            String uuid = UUIDUtil.getUuid();
            layout.setSchema(uuid);
            layout.setType(AppEntrance.COMPONENT_TYPE);
            layoutList.add(layout);
            uiBotModel.setLayout(layoutList);
            //组装金刚区作业数据
            AppEntrance appEntrance = getJobAppEntrance(topicPresetRespList,locale);
            pageData.put(uuid, appEntrance);
            uiBotModel.setPageData(pageData);
        } catch (Exception e) {
            log.debug("myBench/queryClickAppJob req{},error:{}", JSONObject.toJSONString(sysParam), e.getMessage());
            return ApiResponse.buildOK().setData(uiBotModel);
        }
        return ApiResponse.buildOK().setData(uiBotModel);
    }

    /**
     * 组装金刚区作业数据
     *
     * @param topicPresetRespList
     * @return
     */
    public AppEntrance getJobAppEntrance(List<TopicPresetResp> topicPresetRespList,String locale) {
        AppEntrance appEntrance = new AppEntrance();
        List<AppFunctionTouchable> appList = new ArrayList<>();
        for (TopicPresetResp topicPresetResp : topicPresetRespList) {
            List<AppFunctionTouchable> appJobList = addJobTouchable(topicPresetResp.getTopicpList(),locale);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(appJobList)) {
                appList.addAll(appJobList);
            }
        }
        appEntrance.setAppList(appList);
        return appEntrance;
    }

}