package com.digiwin.mobile.mobileuibot.machinePreset.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.machinePreset.service.MachinePresetService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.CompanyFactoryResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class MachinePresetServiceImpl implements MachinePresetService {

    @Autowired
    DigiwinSemcProxyService digiwinSemcProxyService;


    @Override
    public List<CompanyFactoryResp> getCompanyFactoryList(ApiRequest apiRequest) {
        List<JSONObject> list = digiwinSemcProxyService.getCompanyFactory(apiRequest.getLocale(), apiRequest.getIamUserToken());
        List<CompanyFactoryResp> respList = new ArrayList<>();
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(x -> {
                CompanyFactoryResp companyFactoryResp = JSONObject.parseObject(x.toJSONString(), CompanyFactoryResp.class);
                respList.add(companyFactoryResp);
            });
        }
        return respList;
    }

    @Override
    public void saveCompanyFactory(ApiRequest apiRequest, String company, String factory) {
        digiwinSemcProxyService.saveCompanyFactory(apiRequest.getIamUserToken(), company, factory);
    }


    @Override
    public TopicPresetResp queryUserAuth(ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        return digiwinSemcProxyService.queryUserAuth(locale, iamUserToken);
    }

}