package com.digiwin.mobile.mobileuibot.mock;

import com.digiwin.mobile.mobileuibot.mock.request.MockVO;
import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;

import java.util.List;

/**
 * 功能: mock service
 *
 * @author: wjw
 * @date: created at 2023/3/23
 */
public interface MockService {
    /**
     * 获取录制的mock列表
     *
     * @param recordUserId     录制人id
     * @param isMockSuperAdmin 是否超级管理员
     * @return
     */
    List<Mock> mockList(String recordUserId, boolean isMockSuperAdmin);

    /**
     * 根据 录制人和mockId获取数据
     *
     * @param mockId
     * @param recordUserId
     * @return
     */
    Mock selectByMockId(String mockId, String recordUserId);

    /**
     * 删除录制人下的mockid
     *
     * @param mockId
     * @param recordUserId
     * @return
     */
    int delete(String mockId, String recordUserId);

    /**
     * 取消发布当前录制人下的mock
     *
     * @param mockId
     * @param recordUserId
     * @param publish
     * @return
     */
    int publish(String mockId, String recordUserId, Integer publish);

    /**
     * 获取所有mock 分类列表
     *
     * @return
     */
    List<String> categoryList();

    /**
     * 开启录制
     *
     * @param mockVO
     * @return
     */
    MockVO startRecord(MockVO mockVO);

    /**
     * 修改mock 录制体验账号信息
     *
     * @param mockId
     * @param body
     * @return
     */
    String settingMockUserInfo(String mockId, DigiwhaleLoginResponse body);

    /**
     * 获取已发布的mock 列表数据
     *
     * @return
     */
    List<Mock> mockListOfPublish();
}
