package com.digiwin.mobile.mobileuibot.mock;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.mapper.db1.MockMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.mock.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.mock.model.MockCategory;
import com.digiwin.mobile.mobileuibot.mock.request.MockVO;
import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：mock service实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MockServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/11/6 14:10
 */
@Service
public class MockServiceImpl implements MockService {

    @Autowired
    private MockMapper mockMapper;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;

    @Override
    public List<Mock> mockList(String recordUserId, boolean isMockSuperAdmin) {
        LambdaQueryWrapper<Mock> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Mock::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        if (!isMockSuperAdmin) {
            wrapper.eq(Mock::getRecordUserId, recordUserId);
        }
        wrapper.orderByDesc(Mock::getPublish, Mock::getUpdateTime);
        List<Mock> mockList = mockMapper.selectList(wrapper);
        return CollectionUtils.isEmpty(mockList) ? Collections.emptyList() : mockList;
    }

    @Override
    public Mock selectByMockId(String mockId, String recordUserId) {
        LambdaQueryWrapper<Mock> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Mock::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(Mock::getMockId, mockId);
        if (recordUserId != null) {
            wrapper.eq(Mock::getRecordUserId, recordUserId);
        }
        return mockMapper.selectOne(wrapper, false);
    }

    @Override
    public int delete(String mockId, String recordUserId) {
        LambdaUpdateWrapper<Mock> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(Mock::getMockId, mockId);
        updateWrapper.eq(Mock::getRecordUserId, recordUserId);
        updateWrapper.eq(Mock::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        updateWrapper.set(Mock::getDelFlag, DelFlagEnum.DELETE.getValue());
        int i = mockMapper.update(null, updateWrapper);
        digiwinExperienceProxyService.deleteMockData(new OuterMockData().setMockId(mockId));
        return i;
    }

    @Override
    public int publish(String mockId, String recordUserId, Integer publish) {
        LambdaUpdateWrapper<Mock> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(Mock::getMockId, mockId);
        updateWrapper.eq(Mock::getRecordUserId, recordUserId);
        updateWrapper.eq(Mock::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        updateWrapper.set(Mock::getPublish, publish);
        return mockMapper.update(null, updateWrapper);
    }

    @Override
    public List<String> categoryList() {
        Query query = new Query().addCriteria(Criteria.where("verify").is(true))
                .with(Sort.by(Sort.Order.asc("order")));
        List<MockCategory> mockCategories = this.mongoTemplate.find(query, MockCategory.class);
        if (CollectionUtils.isEmpty(mockCategories)) {
            return Collections.emptyList();
        }
        return mockCategories.stream().map(MockCategory::getCategoryName).collect(Collectors.toList());
    }

    @Override
    public MockVO startRecord(MockVO vo) {
        Mock mock = new Mock().setMockName(vo.getMockName()).setApplicationName(vo.getApplicationName())
                .setRecordUserId(vo.getRecordUserId()).setRecordUserName(vo.getRecordUserName())
                .setEnableNana(vo.getEnableNana())
                .setNanaTenantId(vo.getNanaTenantId()).setNanaAdminAccount(vo.getNanaAdminAccount())
                .setNanaAdminPassword(vo.getNanaAdminPassword()).setNanaAuthorizationCode(vo.getNanaAuthorizationCode());
        if (StringUtils.hasLength(vo.getMockId())) {
            // 修改
            mock.setMockId(vo.getMockId());
            mockMapper.updateById(mock);
        } else {
            // 新增
            mock.setMockId(UUIDUtil.getUuid()).setPublish(PublishEnum.UNPUBLISH.getValue())
                    .setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date());
            mockMapper.insert(mock);
        }
        return vo.setMockId(mock.getMockId());
    }

    @Override
    public String settingMockUserInfo(String mockId, DigiwhaleLoginResponse body) {
        Mock mock = mockMapper.selectById(mockId);
        String mockUserId = mock.getMockUserId();
        if (!StringUtils.hasLength(mockUserId)) {
            // 录制体验账号不存在 更新
            Mock update = new Mock().setMockId(mockId)
                    .setMockUserId(body.getIamAuth().getUserId()).setMockUserName(body.getIamAuth().getUserName());
            mockMapper.updateById(update);
            return update.getMockId();
        }
        String userId = body.getIamAuth().getUserId();
        if (mockUserId.equals(userId)) {
            // 录制体验账号存在 且和当前账号相同 不操作
            return mock.getMockId();
        }
        // 录制体验账号存在 且和当前账号不相同 新增
        Mock insert = new Mock().setMockId(UUIDUtil.getUuid()).setMockName(mock.getMockName())
                .setApplicationName(mock.getApplicationName())
                .setRecordUserId(mock.getRecordUserId()).setRecordUserName(mock.getRecordUserName())
                .setMockUserId(body.getIamAuth().getUserId()).setMockUserName(body.getIamAuth().getUserName())
                .setPublish(PublishEnum.UNPUBLISH.getValue())
                .setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date())
                .setEnableNana(mock.getEnableNana())
                .setNanaTenantId(mock.getNanaTenantId()).setNanaAdminAccount(mock.getNanaAdminAccount())
                .setNanaAdminPassword(mock.getNanaAdminPassword()).setNanaAuthorizationCode(mock.getNanaAuthorizationCode());
        mockMapper.insert(insert);
        return insert.getMockId();
    }

    @Override
    public List<Mock> mockListOfPublish() {
        LambdaQueryWrapper<Mock> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Mock::getPublish, PublishEnum.PUBLISH.getValue());
        wrapper.eq(Mock::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByDesc(Mock::getUpdateTime);
        List<Mock> mockList = mockMapper.selectList(wrapper);
        return CollectionUtils.isEmpty(mockList) ? Collections.emptyList() : mockList;
    }
}
