package com.digiwin.mobile.mobileuibot.mock.enums;

import org.springframework.util.ObjectUtils;

/**
 * 具体环境部署的名称
 */
public enum MockDeployEnvironmentEnum {

    HW_PROD("华为正式区"),

    HW_TEST("华为测试区"),

    AZURE_PROD("微软正式区"),

    AZURE_TEST("微软测试区"),

    ALI_PAAS("阿里Paas区");

    private String description;

    MockDeployEnvironmentEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static String getDescriptionByKey(String key) {
        if (ObjectUtils.isEmpty(key)) {
            return null;
        }
        try {
            return MockDeployEnvironmentEnum.valueOf(key.toUpperCase()).description;
        } catch (IllegalArgumentException e) {
            return null;
        }
    }
}
