package com.digiwin.mobile.mobileuibot.mock.enums;

import java.util.Objects;

/**
 * 功能: 是否已发布
 * 是否已发布 0：未发布 1：已发布
 *
 * @author: wjw
 * @date: created at 2023/3/23
 */
public enum PublishEnum {
    /**
     * 未发布
     */
    UNPUBLISH(0),

    /**
     * 已发布
     */
    PUBLISH(1);

    private Integer value;

    PublishEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static PublishEnum exist(Integer value) {
        if (null == value) {
            return null;
        }
        for (PublishEnum publishEnum : PublishEnum.values()) {
            if (Objects.equals(publishEnum.getValue(), value)) {
                return publishEnum;
            }
        }
        return null;
    }
}
