package com.digiwin.mobile.mobileuibot.mock.model;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * @author zhangjj
 * @date 2022/8/31 14:47
 */
@Document(collection = "mockData")
@Data
public class MockData implements Serializable {
    private static final long serialVersionUID = -7607334276297623430L;

    public static final String ROLE_DEFAULT = "default";

    @Id
    private String id;

    /**
     * 请求uri
     */
    private String uri;

    /**
     * 页面id
     */
    private String pageId;

    /**
     * 业务id
     */
    private String dataId;

    /**
     * 语言别
     */
    private String locale;

    /**
     * mock数据
     * key值为default或角色code
     * value为具体mock数据
     * default下为默认mock数据，其他的特定角色下mock数据
     * default必有，特定角色下找不到数据时取用default下mock数据
     */
    private Map<String, Object> body;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MockData mockData = (MockData) o;
        return Objects.equals(id, mockData.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    /**
     * 获取响应的mock数据
     *
     * @param roleCode
     * @return
     */
    public Object getResponseBody(String roleCode) {
        if (body == null) {
            return null;
        }
        if (StringUtils.hasLength(roleCode) && body.containsKey(roleCode)) {
            return body.get(roleCode);
        }
        if (body.containsKey(ROLE_DEFAULT)) {
            return body.get(ROLE_DEFAULT);
        }
        return null;
    }
}
