package com.digiwin.mobile.mobileuibot.mock.model;

import java.util.List;

/**
 * mockData数据表接口
 *
 * @author zhangjj
 * @date 2022/8/31 15:52
 */
public interface MockDataRepository {

    /**
     * 通过uri、pageId获取mock数据
     *
     * @param uri
     * @param pageId
     * @return
     */
    List<MockData> getMockDataList(String uri, String pageId, String requestId);

    /**
     * 通过uri、pageId、dataId、local精确找出mock数据
     * uri、pageId、requestId为必须满足条件，dataId、locale为非必要满足条件
     * 若没找到数据，则返回null
     *
     * @param uri
     * @param pageId
     * @param dataId
     * @param locale
     * @param requestId 首页请求任务、项目使用
     * @return
     */
    MockData getMockData(String uri, String pageId, String dataId, String locale, String requestId);

}
