package com.digiwin.mobile.mobileuibot.mock.model;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangjj
 * @date 2022/9/1 13:58
 */
@Component
public class MockDataRepositoryImpl implements MockDataRepository {

    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<MockData> getMockDataList(String uri, String pageId, String requestId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("uri").is(uri));
        if (RENDER_PAGE_URI.equals(uri)) {
            query.addCriteria(Criteria.where("pageId").is(pageId));
        }
        if (StringUtils.hasLength(requestId)) {
            query.addCriteria(Criteria.where("requestId").is(requestId));
        }
        return mongoTemplate.find(query, MockData.class);
    }


    @Override
    public MockData getMockData(String uri, String pageId, String dataId, String locale, String requestId) {
        List<MockData> mockDataList = getMockDataList(uri, pageId, requestId);
        if (CollectionUtils.isEmpty(mockDataList)) {
            return null;
        }
        if (mockDataList.size() == 1) {
            return mockDataList.get(0);
        }
        //按dataId筛选的结果
        List<MockData> dataIdMockDataList = new ArrayList<>();
        //按locale筛选的结果
        List<MockData> localeMockDataList = new ArrayList<>();
        if (StringUtils.hasLength(dataId)) {
            dataIdMockDataList = mockDataList.stream().filter(mockData -> dataId.equalsIgnoreCase(mockData.getDataId())).collect(Collectors.toList());
        }
        if (StringUtils.hasLength(locale)) {
            localeMockDataList = mockDataList.stream().filter(mockData -> locale.equalsIgnoreCase(mockData.getLocale())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dataIdMockDataList) && CollectionUtils.isEmpty(localeMockDataList)) {
            //均为空，返回原list第一笔数据
            return mockDataList.get(0);
        }
        if (!CollectionUtils.isEmpty(dataIdMockDataList) && !CollectionUtils.isEmpty(localeMockDataList)) {
            //均不为空，找出相同元素
            List<MockData> dataIdLocaleMockDataList = new ArrayList<>();
            for (MockData mockData : dataIdMockDataList) {
                if (localeMockDataList.contains(mockData)) {
                    dataIdLocaleMockDataList.add(mockData);
                }
            }
            if (CollectionUtils.isEmpty(dataIdLocaleMockDataList)) {
                return dataIdMockDataList.get(0);
            }
            return dataIdLocaleMockDataList.get(0);
        }
        //有一个为空，取不为空list的第一笔数据
        return CollectionUtils.isEmpty(dataIdMockDataList) ? localeMockDataList.get(0) : dataIdMockDataList.get(0);
    }
}
