package com.digiwin.mobile.mobileuibot.mock.v2;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleResponseData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.io.Serializable;
import java.util.Map;

/**
 * 单/多档 mockV2版本数据
 *
 * @author yanfeng
 * @date 2023/9/22
 */

@Document("mockV2Data")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MockV2Model implements Serializable {


    private static final long serialVersionUID = -4987225020291683697L;
    @MongoId
    private String id;

    /**
     * 设计器约定tmActivityId包含key
     *
     * @see MockV2Constants
     */
    private String key;

    /**
     * 备注说明
     */
    private String remark;


    /**
     * mock任务卡数据
     */
    private QueryResultSet data;

    /**
     * 开窗数据
     */
    private Map<String, InputWindowSingleResponseData> windowingData;

    /**
     * 提交数据
     */
    private Map<String, ActionSubmitResult> submitData;
}
