package com.digiwin.mobile.mobileuibot.mock.v2;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

/**
 * @author yanfeng
 * @date 2023/10/8
 */
@Slf4j
@Service
public class MockV2ServiceImpl implements MockV2Service {

    @Autowired
    private MongoTemplate mongoTemplate;


    @Override
    public MockV2Model getMockV2Model(String key) {
        try {
            Query query = new Query();
            query.addCriteria(Criteria.where("key").is(key));
            return mongoTemplate.findOne(query, MockV2Model.class);
        } catch (Exception e) {
            log.error("getMockV2Model异常:{}", e.getMessage());
        }
        return null;
    }

    @Override
    public void insertOrUpdateMockV2Data(MockV2Model mockV2Model) {
        try {
            Query query = new Query();
            query.addCriteria(Criteria.where("key").is(mockV2Model.getKey()));
            MockV2Model one = mongoTemplate.findOne(query, MockV2Model.class);
            if (ObjectUtils.isNotEmpty(one)) {
                Update update = new Update();
                if (ObjectUtils.isNotEmpty(mockV2Model.getData())) {
                    update.set("data", mockV2Model.getData());
                }
                if (ObjectUtils.isNotEmpty(mockV2Model.getWindowingData())) {
                    update.set("windowingData", mockV2Model.getWindowingData());
                }
                if (ObjectUtils.isNotEmpty(mockV2Model.getSubmitData())) {
                    update.set("submitData", mockV2Model.getSubmitData());
                }
                mongoTemplate.updateMulti(query, update, MockV2Model.class);
            } else {
                mongoTemplate.save(mockV2Model);
            }
        } catch (Exception e) {
            log.error("insertOrUpdateMockV2Data异常:{}", e.getMessage());
            throw new ServiceException("操作异常");
        }
    }
}
