package com.digiwin.mobile.mobileuibot.mongodb.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * mongoDB查询DTO
 *
 * @author yanfeng
 * @date 2024/1/31
 */
@Data
public class MongoDbQueryDTO {

    /**
     * 集合名称
     */
    @NotBlank(message = "collectionName不能为空")
    private String collectionName;

    /**
     * 查询结果显示字段
     */
    private String includeField;
    // 查询结果显示字段
    private List<String> includeFields;
    // 查询结果排除字段
    private List<String> excludeFields;

    /**
     * 根据id查询
     */
    private String id;
    // 查询条件字段
    private Map<String, Object> queryField;

    /**
     * 口令
     */
    @NotBlank(message = "口令不能为空")
    private String wordOfCommand;

    /**
     * 主副库名称
     */
    @NotBlank(message = "主副库名称不能为空")
    private String databaseName;
}
