package com.digiwin.mobile.mobileuibot.mongodb.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * mongoDB查询DTO
 *
 * @author yanfeng
 * @date 2024/1/31
 */
@Data
public class MongoDbUpdateDTO {

    /**
     * 集合名称
     */
    @NotBlank(message = "collectionName不能为空")
    private String collectionName;

    /**
     * 根据id查询
     */
    @NotBlank(message = "id不能为空")
    private String id;

    /**
     * 更新数据
     * key对应数据库字段，value对应值
     */
    private Map<String, Object> mapData;

    /**
     * 口令
     */
    @NotBlank(message = "口令不能为空")
    private String wordOfCommand;

    /**
     * 主副库名称
     */
    @NotBlank(message = "主副库名称不能为空")
    private String databaseName;
}
