package com.digiwin.mobile.mobileuibot.mongodb.uc;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>功能描述：操作 MongoDB，获取 uc_pageTaskRelation 数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UcPageTaskRelationRepository.java
 * @Author: wangjwc
 * @Date: created at 2025/2/8 13:44
 */
@Component
public class UcPageTaskRelationRepository {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public List<UcPageTaskRelation> listAthenaPageTaskRelations(String version, Set<String> ucAppCodeList) {
        Query query = new Query();
        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
                .addCriteria(Criteria.where("version").is(version))
                .addCriteria(Criteria.where("ucAppCode").in(ucAppCodeList));

        return this.mongoTemplate.find(query, UcPageTaskRelation.class)
                .stream().filter(pageTaskRelation -> pageTaskRelation.validWithAppEnvType(AppContext.getEnvType()))
                .collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        // AB库同时操作
        mongoTemplate.findAllAndRemove(query, UcPageTaskRelation.class);
        secondMongoTemplate.findAllAndRemove(query, UcPageTaskRelation.class);
    }

    public List<UcPageTaskRelation> selectByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        List<UcPageTaskRelation> list = mongoTemplate.find(query, UcPageTaskRelation.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }

    public void batchInsert(List<UcPageTaskRelation> pageTaskRelations) {
        if (CollectionUtils.isEmpty(pageTaskRelations)) {
            return;
        }
        // AB库同时操作
        mongoTemplate.insertAll(pageTaskRelations);
        secondMongoTemplate.insertAll(pageTaskRelations);
    }
}
