package com.digiwin.mobile.mobileuibot.mongodb.uc;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>功能描述：操作 MongoDB，获取 uc_taskFilter 数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UcTaskFilterRepository.java
 * @Author: wangjwc
 * @Date: created at 2025/2/8 13:43
 */
@Component
public class UcTaskFilterRepository {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public List<UcTaskFilter> listValidInAthena(String version, Set<String> ucAppCodeList) {
        Query query = new Query();
        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
                .addCriteria(Criteria.where("valid").is(true))
                .addCriteria(Criteria.where("version").is(version))
                .addCriteria(Criteria.where("ucAppCode").in(ucAppCodeList));

        // 查到所有有效任务过滤配置后，再过滤出当前启动环境下有效的配置
        return this.mongoTemplate.find(query, UcTaskFilter.class)
                .stream().filter(filter -> filter.validWithAppEnvType(AppContext.getEnvType()))
                .collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        // AB库同时操作
        mongoTemplate.findAllAndRemove(query, UcTaskFilter.class);
        secondMongoTemplate.findAllAndRemove(query, UcTaskFilter.class);
    }

    public List<UcTaskFilter> selectByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        List<UcTaskFilter> list = mongoTemplate.find(query, UcTaskFilter.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }

    public void batchInsert(List<UcTaskFilter> taskFilters) {
        if (CollectionUtils.isEmpty(taskFilters)) {
            return;
        }
        // AB库同时操作
        mongoTemplate.insertAll(taskFilters);
        secondMongoTemplate.insertAll(taskFilters);
    }
}
