package com.digiwin.mobile.mobileuibot.mongodb.uc;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;

/**
 * <p>功能描述：个案与使用租户关联表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UcTenantRelation.java
 * @Author: wangjwc
 * @Date: created at 2025/2/8 13:34
 */
@Data
@Accessors(chain = true)
@Document(collection = "uc_tenantRelation")
public class UcTenantRelation implements Serializable {
    private static final long serialVersionUID = -2710368634491387880L;

    @Id
    private String id;
    // 应用代号
    private String appCode;
    // 个案应用代号
    private String ucAppCode;
    // 使用租户ID
    private String tenantId;
    // 是否开启任务定制,true:开启
    private Boolean individualAll;
    // 数据版本
    private String version;
    private String createTime;
    private String updateTime;
}
