package com.digiwin.mobile.mobileuibot.mongodb.uc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：操作 MongoDB，获取 uc_tenantRelation 数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UcTenantRelationRepository.java
 * @Author: wangjwc
 * @Date: created at 2025/2/8 13:53
 */
@Component
public class UcTenantRelationRepository {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public void deleteByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        // AB库同时操作
        mongoTemplate.findAllAndRemove(query, UcTenantRelation.class);
        secondMongoTemplate.findAllAndRemove(query, UcTenantRelation.class);
    }

    public List<UcTenantRelation> selectByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("ucAppCode").is(ucAppCode))
                .addCriteria(Criteria.where("version").is(version));
        List<UcTenantRelation> list = mongoTemplate.find(query, UcTenantRelation.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }

    public void batchInsert(List<UcTenantRelation> tenantRelations) {
        if (CollectionUtils.isEmpty(tenantRelations)) {
            return;
        }
        // AB库同时操作
        mongoTemplate.insertAll(tenantRelations);
        secondMongoTemplate.insertAll(tenantRelations);
    }

    public List<UcTenantRelation> selectByTenantId(String tenantId, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId))
                .addCriteria(Criteria.where("version").is(version));
        List<UcTenantRelation> list = mongoTemplate.find(query, UcTenantRelation.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }
}
